/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.AttributeObserver;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaPropertyNode;
import com.digitalpetri.opcua.sdk.server.util.StreamUtil;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaNode
implements Node {
    private static final Logger LOGGER = LoggerFactory.getLogger(UaNode.class);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final List<Reference> references = new CopyOnWriteArrayList<Reference>();
    private List<WeakReference<AttributeObserver>> observers;
    private final UaNamespace namespace;
    private volatile NodeId nodeId;
    private volatile NodeClass nodeClass;
    private volatile QualifiedName browseName;
    private volatile LocalizedText displayName;
    private volatile Optional<LocalizedText> description;
    private volatile Optional<UInteger> writeMask;
    private volatile Optional<UInteger> userWriteMask;

    protected UaNode(UaNamespace namespace, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName) {
        this(namespace, nodeId, nodeClass, browseName, displayName, Optional.empty(), Optional.empty(), Optional.empty());
    }

    protected UaNode(UaNamespace namespace, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask) {
        this.namespace = namespace;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    @Override
    public Optional<LocalizedText> getDescription() {
        return this.description;
    }

    @Override
    public Optional<UInteger> getWriteMask() {
        return this.writeMask;
    }

    @Override
    public Optional<UInteger> getUserWriteMask() {
        return this.userWriteMask;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
        this.fireAttributeChanged(1, nodeId);
    }

    @Override
    public synchronized void setNodeClass(NodeClass nodeClass) {
        this.nodeClass = nodeClass;
        this.fireAttributeChanged(2, nodeClass);
    }

    @Override
    public synchronized void setBrowseName(QualifiedName browseName) {
        this.browseName = browseName;
        this.fireAttributeChanged(3, browseName);
    }

    @Override
    public synchronized void setDisplayName(LocalizedText displayName) {
        this.displayName = displayName;
        this.fireAttributeChanged(4, displayName);
    }

    @Override
    public synchronized void setDescription(Optional<LocalizedText> description) {
        this.description = description;
        description.ifPresent(v -> this.fireAttributeChanged(5, v));
    }

    @Override
    public synchronized void setWriteMask(Optional<UInteger> writeMask) {
        this.writeMask = writeMask;
        writeMask.ifPresent(v -> this.fireAttributeChanged(6, v));
    }

    @Override
    public synchronized void setUserWriteMask(Optional<UInteger> userWriteMask) {
        this.userWriteMask = userWriteMask;
        userWriteMask.ifPresent(v -> this.fireAttributeChanged(7, v));
    }

    public UaNamespace getNamespace() {
        return this.namespace;
    }

    protected Optional<UaNode> getNode(NodeId nodeId) {
        return this.namespace.getNode(nodeId);
    }

    protected Optional<UaNode> getNode(ExpandedNodeId nodeId) {
        return this.namespace.getNode(nodeId);
    }

    public ImmutableList<Reference> getReferences() {
        return ImmutableList.copyOf(this.references);
    }

    public synchronized void addReference(Reference reference) {
        this.references.add(reference);
        if (reference.isInverse()) {
            int count = this.refCount.incrementAndGet();
            LOGGER.debug("{} refCount={}", (Object)this.getNodeId(), (Object)count);
            if (count == 1) {
                this.namespace.addNode(this);
            }
        }
    }

    public synchronized void addReferences(Collection<Reference> c) {
        c.forEach(this::addReference);
    }

    public synchronized void removeReference(Reference reference) {
        this.references.remove(reference);
        if (reference.isInverse()) {
            int count = this.refCount.decrementAndGet();
            LOGGER.debug("{} refCount={}", (Object)this.getNodeId(), (Object)count);
            if (count == 0) {
                this.deallocate();
            }
        }
    }

    public synchronized void removeReferences(Collection<Reference> c) {
        c.forEach(this::removeReference);
    }

    protected synchronized void deallocate() {
        LOGGER.debug("{} deallocate()", (Object)this.getNodeId());
        ExpandedNodeId expanded = this.getNodeId().expanded();
        List referencedNodes = this.getReferences().stream().filter(Reference::isForward).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
        for (UaNode node : referencedNodes) {
            List<Reference> inverseReferences = node.getReferences().stream().filter(Reference::isInverse).filter(r -> r.getTargetNodeId().equals((Object)expanded)).collect(Collectors.toList());
            node.removeReferences(inverseReferences);
        }
        this.namespace.removeNode(this.getNodeId());
    }

    public <T> Optional<T> getProperty(Property<T> property) {
        return this.getProperty(property.getBrowseName());
    }

    public <T> Optional<T> getProperty(String browseName) {
        return this.getProperty(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public <T> Optional<T> getProperty(QualifiedName browseName) {
        Node node = this.getPropertyNode(browseName).orElse(null);
        try {
            return Optional.ofNullable(((VariableNode)node).getValue().getValue().getValue());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public <T> void setProperty(Property<T> property, T value) {
        VariableNode node = this.getPropertyNode(property.getBrowseName()).orElseGet(() -> {
            QualifiedName browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName.getName()));
            UaPropertyNode propertyNode = new UaPropertyNode(this.getNamespace(), propertyNodeId, browseName, LocalizedText.english((String)browseName.getName()));
            propertyNode.setDataType(property.getDataType());
            propertyNode.setValueRank(property.getValueRank());
            propertyNode.setArrayDimensions(property.getArrayDimensions());
            this.addProperty(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public Optional<VariableNode> getPropertyNode(String browseName) {
        return this.getPropertyNode(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedName browseName) {
        Node node = this.references.stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        try {
            return Optional.ofNullable((VariableNode)node);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public void addProperty(UaPropertyNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), NodeClass.Variable, true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    public void removeProperty(UaPropertyNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), NodeClass.Variable, true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    protected Optional<ObjectNode> getObjectComponent(String browseName) {
        return this.getObjectComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<ObjectNode> getObjectComponent(QualifiedName browseName) {
        ObjectNode node = this.references.stream().filter(Reference.HAS_COMPONENT_PREDICATE.and(r -> r.getTargetNodeClass() == NodeClass.Object)).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    protected Optional<VariableNode> getVariableComponent(String browseName) {
        return this.getVariableComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<VariableNode> getVariableComponent(QualifiedName browseName) {
        VariableNode node = this.references.stream().filter(Reference.HAS_COMPONENT_PREDICATE.and(r -> r.getTargetNodeClass() == NodeClass.Variable)).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    public synchronized void addAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            this.observers = new LinkedList<WeakReference<AttributeObserver>>();
        }
        this.observers.add(new WeakReference<AttributeObserver>(observer));
    }

    public synchronized void removeAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            if (ref.get() != null && ref.get() != observer) continue;
            iterator.remove();
        }
        if (this.observers.isEmpty()) {
            this.observers = null;
        }
    }

    protected synchronized void fireAttributeChanged(int attributeId, Object attributeValue) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            AttributeObserver observer = (AttributeObserver)ref.get();
            if (observer != null) {
                observer.attributeChanged(this, attributeId, attributeValue);
                continue;
            }
            iterator.remove();
        }
    }
}

