/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.model.UaObjectNode;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;

public class UaFolderNode
extends UaObjectNode {
    public UaFolderNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(namespace, nodeId, browseName, displayName);
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.FolderType.expanded(), NodeClass.ObjectType, true));
    }

    public void addOrganizes(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.Organizes, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.Organizes, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    public void removeOrganizes(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.Organizes, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.Organizes, this.getNodeId().expanded(), this.getNodeClass(), false));
    }
}

