/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.identity;

import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.channel.SecureChannel;
import com.digitalpetri.opcua.stack.core.security.SecurityAlgorithm;
import com.digitalpetri.opcua.stack.core.types.structured.AnonymousIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.IssuedIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserNameIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserTokenPolicy;
import com.digitalpetri.opcua.stack.core.types.structured.X509IdentityToken;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class IdentityValidator {
    public Object validateAnonymousToken(AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        throw new UaException(0x80200000L);
    }

    public Object validateUsernameToken(UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        throw new UaException(0x80200000L);
    }

    public Object validateX509Token(X509IdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        throw new UaException(0x80200000L);
    }

    public Object validateIssuedIdentityToken(IssuedIdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected byte[] decryptTokenData(SecureChannel secureChannel, SecurityAlgorithm algorithm, byte[] dataBytes) throws UaException {
        int cipherTextBlockSize = secureChannel.getLocalAsymmetricCipherTextBlockSize();
        int blockCount = dataBytes.length / cipherTextBlockSize;
        int plainTextBufferSize = cipherTextBlockSize * blockCount;
        byte[] plainTextBytes = new byte[plainTextBufferSize];
        ByteBuffer plainTextNioBuffer = ByteBuffer.wrap(plainTextBytes);
        ByteBuffer passwordNioBuffer = ByteBuffer.wrap(dataBytes);
        try {
            Cipher cipher = this.getCipher(secureChannel, algorithm);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                passwordNioBuffer.limit(passwordNioBuffer.position() + cipherTextBlockSize);
                cipher.doFinal(passwordNioBuffer, plainTextNioBuffer);
            }
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
        return plainTextBytes;
    }

    private Cipher getCipher(SecureChannel channel, SecurityAlgorithm algorithm) throws UaException {
        try {
            String transformation = algorithm.getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, channel.getKeyPair().getPrivate());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

