/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.core.nodes;

import com.digitalpetri.opcua.sdk.server.NamespaceManager;
import com.digitalpetri.opcua.sdk.server.util.AttributeReader;
import com.digitalpetri.opcua.sdk.server.util.AttributeWriter;
import com.digitalpetri.opcua.stack.core.AttributeId;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Node {
    public NodeId getNodeId();

    public NodeClass getNodeClass();

    public QualifiedName getBrowseName();

    public LocalizedText getDisplayName();

    public Optional<LocalizedText> getDescription();

    public Optional<UInteger> getWriteMask();

    public Optional<UInteger> getUserWriteMask();

    public void setNodeId(NodeId var1);

    public void setNodeClass(NodeClass var1);

    public void setBrowseName(QualifiedName var1);

    public void setDisplayName(LocalizedText var1);

    public void setDescription(Optional<LocalizedText> var1);

    public void setWriteMask(Optional<UInteger> var1);

    public void setUserWriteMask(Optional<UInteger> var1);

    default public boolean hasAttribute(int attributeId) {
        return 2150957056L != this.readAttribute(attributeId).getStatusCode().getValue();
    }

    default public boolean hasAttribute(UInteger attributeId) {
        return this.hasAttribute(attributeId.intValue());
    }

    default public DataValue readAttribute(UInteger attribute) {
        return this.readAttribute(attribute.intValue());
    }

    default public DataValue readAttribute(int attribute) {
        return this.readAttribute(attribute, null, null);
    }

    default public DataValue readAttribute(int attribute, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange) {
        return AttributeId.from((int)attribute).map(attributeId -> this.readAttribute((AttributeId)attributeId, timestamps, indexRange)).orElse(new DataValue(2150957056L));
    }

    default public DataValue readAttribute(AttributeId attributeId) {
        return this.readAttribute(attributeId, null, null);
    }

    default public DataValue readAttribute(AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange) {
        return AttributeReader.readAttribute(this, attributeId, timestamps, indexRange);
    }

    default public void writeAttribute(NamespaceManager ns, UInteger attribute, DataValue value, String indexRange) throws UaException {
        this.writeAttribute(ns, attribute.intValue(), value, indexRange);
    }

    default public void writeAttribute(NamespaceManager ns, int attribute, DataValue value, String indexRange) throws UaException {
        Optional attributeId = AttributeId.from((int)attribute);
        if (!attributeId.isPresent()) {
            throw new UaException(2150957056L);
        }
        this.writeAttribute(ns, (AttributeId)attributeId.get(), value, indexRange);
    }

    default public void writeAttribute(NamespaceManager ns, AttributeId attributeId, DataValue value, String indexRange) throws UaException {
        AttributeWriter.writeAttribute(ns, this, attributeId, value, indexRange);
    }
}

