/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.core;

import com.digitalpetri.opcua.stack.core.UaRuntimeException;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServerTable {
    private final BiMap<Integer, String> uriTable = HashBiMap.create();

    public synchronized int addUri(String uri) {
        int index = 1;
        while (this.uriTable.containsKey((Object)index)) {
            if (++index != 65535) continue;
            throw new UaRuntimeException(0x80020000L, "uri table full");
        }
        this.uriTable.put((Object)index, (Object)uri);
        return index;
    }

    public synchronized void putUri(String uri, int index) {
        this.uriTable.put((Object)index, (Object)uri);
    }

    public synchronized String getUri(int index) {
        return (String)this.uriTable.get((Object)index);
    }

    public synchronized int getIndex(String uri) {
        return (Integer)this.uriTable.inverse().get((Object)uri);
    }

    public synchronized String[] toArray() {
        List<String> uris = this.uriTable.entrySet().stream().sorted((e1, e2) -> (Integer)e1.getKey() - (Integer)e2.getKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        return uris.toArray(new String[uris.size()]);
    }
}

