/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.master;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.ModbusResponseException;
import com.digitalpetri.modbus.ModbusTimeoutException;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.codec.ModbusRequestEncoder;
import com.digitalpetri.modbus.codec.ModbusResponseDecoder;
import com.digitalpetri.modbus.codec.ModbusTcpCodec;
import com.digitalpetri.modbus.codec.ModbusTcpPayload;
import com.digitalpetri.modbus.master.ModbusTcpMasterConfig;
import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.responses.ExceptionResponse;
import com.digitalpetri.modbus.responses.ModbusResponse;
import com.digitalpetri.netty.fsm.ChannelActions;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmFactory;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.State;
import com.digitalpetri.strictmachine.FsmContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpMaster {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Short, PendingRequest<? extends ModbusResponse>> pendingRequests = new ConcurrentHashMap<Short, PendingRequest<? extends ModbusResponse>>();
    private final AtomicInteger transactionId = new AtomicInteger(0);
    private final Map<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    private final Counter requestCounter = new Counter();
    private final Counter responseCounter = new Counter();
    private final Counter lateResponseCounter = new Counter();
    private final Counter timeoutCounter = new Counter();
    private final Timer responseTimer = new Timer();
    private final ChannelFsm channelFsm;
    private final ModbusTcpMasterConfig config;

    public ModbusTcpMaster(ModbusTcpMasterConfig config) {
        this.config = config;
        ChannelFsmConfig fsmConfig = ChannelFsmConfig.newBuilder().setLazy(config.isLazy()).setPersistent(config.isPersistent()).setMaxIdleSeconds(8).setMaxReconnectDelaySeconds(config.getMaxReconnectDelaySeconds()).setChannelActions((ChannelActions)new ModbusChannelActions(this)).setExecutor((Executor)config.getExecutor()).setScheduler(config.getScheduler()).setLoggerName("com.digitalpetri.modbus.ChannelFsm").build();
        this.channelFsm = ChannelFsmFactory.newChannelFsm((ChannelFsmConfig)fsmConfig);
        this.metrics.put(this.metricName("request-counter"), (Metric)this.requestCounter);
        this.metrics.put(this.metricName("response-counter"), (Metric)this.responseCounter);
        this.metrics.put(this.metricName("late-response-counter"), (Metric)this.lateResponseCounter);
        this.metrics.put(this.metricName("timeout-counter"), (Metric)this.timeoutCounter);
        this.metrics.put(this.metricName("response-timer"), (Metric)this.responseTimer);
    }

    public ModbusTcpMasterConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<ModbusTcpMaster> connect() {
        return this.channelFsm.connect().thenApply(ch -> this);
    }

    public CompletableFuture<ModbusTcpMaster> disconnect() {
        return this.channelFsm.disconnect().thenApply(v -> this);
    }

    public <T extends ModbusResponse> CompletableFuture<T> sendRequest(ModbusRequest request, int unitId) {
        CompletableFuture future = new CompletableFuture();
        this.channelFsm.getChannel().whenComplete((ch, ex) -> {
            if (ch != null) {
                short txId = (short)this.transactionId.incrementAndGet();
                Timeout timeout = this.config.getWheelTimer().newTimeout(t -> {
                    if (t.isCancelled()) {
                        return;
                    }
                    PendingRequest<? extends ModbusResponse> timedOut = this.pendingRequests.remove(txId);
                    if (timedOut != null) {
                        ((PendingRequest)timedOut).promise.completeExceptionally((Throwable)new ModbusTimeoutException(this.config.getTimeout()));
                        this.timeoutCounter.inc();
                    }
                }, this.config.getTimeout().getSeconds(), TimeUnit.SECONDS);
                Timer.Context context = this.responseTimer.time();
                this.pendingRequests.put(txId, new PendingRequest(future, timeout, context));
                ch.writeAndFlush((Object)new ModbusTcpPayload(txId, (short)unitId, (ModbusPdu)request)).addListener(f -> {
                    PendingRequest<? extends ModbusResponse> p;
                    if (!f.isSuccess() && (p = this.pendingRequests.remove(txId)) != null) {
                        ((PendingRequest)p).promise.completeExceptionally(f.cause());
                        ((PendingRequest)p).timeout.cancel();
                    }
                });
                this.requestCounter.inc();
            } else {
                future.completeExceptionally((Throwable)ex);
            }
        });
        return future;
    }

    private void onChannelRead(ChannelHandlerContext ctx, ModbusTcpPayload payload) {
        ModbusPdu modbusPdu = payload.getModbusPdu();
        if (modbusPdu instanceof ModbusResponse) {
            this.config.getExecutor().submit(() -> this.handleResponse(payload.getTransactionId(), payload.getUnitId(), (ModbusResponse)modbusPdu));
        } else {
            this.logger.error("Unexpected ModbusPdu: {}", (Object)modbusPdu);
        }
    }

    private void handleResponse(short transactionId, short unitId, ModbusResponse response) {
        PendingRequest<? extends ModbusResponse> pending = this.pendingRequests.remove(transactionId);
        if (pending != null) {
            this.responseCounter.inc();
            ((PendingRequest)pending).context.stop();
            ((PendingRequest)pending).timeout.cancel();
            if (response instanceof ExceptionResponse) {
                ((PendingRequest)pending).promise.completeExceptionally((Throwable)new ModbusResponseException((ExceptionResponse)response));
            } else {
                ((PendingRequest)pending).promise.complete(response);
            }
        } else {
            this.lateResponseCounter.inc();
            ReferenceCountUtil.release((Object)response);
            this.logger.debug("Received response for unknown transactionId: {}", (Object)transactionId);
        }
    }

    private void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failPendingRequests(cause);
        ctx.close();
        this.onExceptionCaught(ctx, cause);
    }

    protected void onExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.debug("Exception caught: {}", (Object)cause.getMessage(), (Object)cause);
    }

    private void failPendingRequests(Throwable cause) {
        ArrayList<PendingRequest<? extends ModbusResponse>> pending = new ArrayList<PendingRequest<? extends ModbusResponse>>(this.pendingRequests.values());
        pending.forEach(p -> ((PendingRequest)p).promise.completeExceptionally(cause));
        this.pendingRequests.clear();
    }

    public MetricSet getMetricSet() {
        return () -> this.metrics;
    }

    public Counter getRequestCounter() {
        return this.requestCounter;
    }

    public Counter getResponseCounter() {
        return this.responseCounter;
    }

    public Counter getLateResponseCounter() {
        return this.lateResponseCounter;
    }

    public Counter getTimeoutCounter() {
        return this.timeoutCounter;
    }

    public Timer getResponseTimer() {
        return this.responseTimer;
    }

    private String metricName(String name) {
        String instanceId = this.config.getInstanceId().orElse(null);
        return MetricRegistry.name(ModbusTcpMaster.class, (String[])new String[]{instanceId, name});
    }

    public static CompletableFuture<Channel> bootstrap(final ModbusTcpMaster master, ModbusTcpMasterConfig config) {
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        Bootstrap bootstrap = new Bootstrap();
        config.getBootstrapConsumer().accept(bootstrap);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(config.getEventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)config.getTimeout().toMillis()))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusTcpCodec((ModbusPduEncoder)new ModbusRequestEncoder(), (ModbusPduDecoder)new ModbusResponseDecoder())});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusTcpMasterHandler(master)});
            }
        })).connect(config.getAddress(), config.getPort()).addListener(f -> {
            if (f.isSuccess()) {
                future.complete(f.channel());
            } else {
                future.completeExceptionally(f.cause());
            }
        });
        return future;
    }

    private static class ModbusChannelActions
    implements ChannelActions {
        private final Logger logger = LoggerFactory.getLogger(ModbusTcpMaster.class);
        private final ModbusTcpMaster master;

        ModbusChannelActions(ModbusTcpMaster master) {
            this.master = master;
        }

        public CompletableFuture<Channel> connect(FsmContext<State, Event> fsmContext) {
            return ModbusTcpMaster.bootstrap(this.master, this.master.getConfig()).whenComplete((ch, ex) -> {
                if (ch != null) {
                    this.logger.debug("Channel bootstrap succeeded: localAddress={}, remoteAddress={}", (Object)ch.localAddress(), (Object)ch.remoteAddress());
                } else {
                    this.logger.debug("Channel bootstrap failed: {}", (Object)ex.getMessage(), ex);
                }
            });
        }

        public CompletableFuture<Void> disconnect(FsmContext<State, Event> fsmContext, Channel channel) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> future.complete(null)));
            return future;
        }
    }

    private static class PendingRequest<T> {
        private final CompletableFuture<ModbusResponse> promise = new CompletableFuture();
        private final Timeout timeout;
        private final Timer.Context context;

        private PendingRequest(CompletableFuture<T> future, Timeout timeout, Timer.Context context) {
            this.timeout = timeout;
            this.context = context;
            this.promise.whenComplete((r, ex) -> {
                if (r != null) {
                    try {
                        future.complete(r);
                    }
                    catch (ClassCastException e) {
                        future.completeExceptionally(e);
                    }
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
            });
        }
    }

    private static class ModbusTcpMasterHandler
    extends SimpleChannelInboundHandler<ModbusTcpPayload> {
        private final ModbusTcpMaster master;

        private ModbusTcpMasterHandler(ModbusTcpMaster master) {
            this.master = master;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ModbusTcpPayload msg) {
            this.master.onChannelRead(ctx, msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.master.exceptionCaught(ctx, cause);
        }
    }
}

