/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus;

import java.util.Optional;

public enum FunctionCode {
    ReadCoils(1),
    ReadDiscreteInputs(2),
    ReadHoldingRegisters(3),
    ReadInputRegisters(4),
    WriteSingleCoil(5),
    WriteSingleRegister(6),
    ReadExceptionStatus(7),
    Diagnostics(8),
    GetCommEventCounter(11),
    GetCommEventLog(12),
    WriteMultipleCoils(15),
    WriteMultipleRegisters(16),
    ReportSlaveId(17),
    ReadFileRecord(20),
    WriteFileRecord(21),
    MaskWriteRegister(22),
    ReadWriteMultipleRegisters(23),
    ReadFifoQueue(24),
    EncapsulatedInterfaceTransport(43);

    private final int code;

    private FunctionCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static Optional<FunctionCode> fromCode(int code) {
        switch (code) {
            case 1: {
                return Optional.of(ReadCoils);
            }
            case 2: {
                return Optional.of(ReadDiscreteInputs);
            }
            case 3: {
                return Optional.of(ReadHoldingRegisters);
            }
            case 4: {
                return Optional.of(ReadInputRegisters);
            }
            case 5: {
                return Optional.of(WriteSingleCoil);
            }
            case 6: {
                return Optional.of(WriteSingleRegister);
            }
            case 7: {
                return Optional.of(ReadExceptionStatus);
            }
            case 8: {
                return Optional.of(Diagnostics);
            }
            case 11: {
                return Optional.of(GetCommEventCounter);
            }
            case 12: {
                return Optional.of(GetCommEventLog);
            }
            case 15: {
                return Optional.of(WriteMultipleCoils);
            }
            case 16: {
                return Optional.of(WriteMultipleRegisters);
            }
            case 17: {
                return Optional.of(ReportSlaveId);
            }
            case 20: {
                return Optional.of(ReadFileRecord);
            }
            case 21: {
                return Optional.of(WriteFileRecord);
            }
            case 22: {
                return Optional.of(MaskWriteRegister);
            }
            case 23: {
                return Optional.of(ReadWriteMultipleRegisters);
            }
            case 24: {
                return Optional.of(ReadFifoQueue);
            }
            case 43: {
                return Optional.of(EncapsulatedInterfaceTransport);
            }
        }
        return Optional.empty();
    }

    public static boolean isExceptionCode(int code) {
        return FunctionCode.fromCode(code - 128).isPresent();
    }
}

