/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.requests.MaskWriteRegisterRequest;
import com.digitalpetri.modbus.requests.ReadCoilsRequest;
import com.digitalpetri.modbus.requests.ReadDiscreteInputsRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.requests.ReadInputRegistersRequest;
import com.digitalpetri.modbus.requests.WriteMultipleCoilsRequest;
import com.digitalpetri.modbus.requests.WriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteSingleCoilRequest;
import com.digitalpetri.modbus.requests.WriteSingleRegisterRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;

public class ModbusRequestEncoder
implements ModbusPduEncoder {
    @Override
    public ByteBuf encode(ModbusPdu modbusPdu, ByteBuf buffer) throws EncoderException {
        try {
            switch (modbusPdu.getFunctionCode()) {
                case ReadCoils: {
                    ByteBuf byteBuf = this.encodeReadCoils((ReadCoilsRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadDiscreteInputs: {
                    ByteBuf byteBuf = this.encodeReadDiscreteInputs((ReadDiscreteInputsRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadHoldingRegisters: {
                    ByteBuf byteBuf = this.encodeReadHoldingRegisters((ReadHoldingRegistersRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadInputRegisters: {
                    ByteBuf byteBuf = this.encodeReadInputRegisters((ReadInputRegistersRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteSingleCoil: {
                    ByteBuf byteBuf = this.encodeWriteSingleCoil((WriteSingleCoilRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteSingleRegister: {
                    ByteBuf byteBuf = this.encodeWriteSingleRegister((WriteSingleRegisterRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteMultipleCoils: {
                    ByteBuf byteBuf = this.encodeWriteMultipleCoils((WriteMultipleCoilsRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteMultipleRegisters: {
                    ByteBuf byteBuf = this.encodeWriteMultipleRegisters((WriteMultipleRegistersRequest)modbusPdu, buffer);
                    return byteBuf;
                }
                case MaskWriteRegister: {
                    ByteBuf byteBuf = this.encodeMaskWriteRegister((MaskWriteRegisterRequest)modbusPdu, buffer);
                    return byteBuf;
                }
            }
            throw new EncoderException("FunctionCode not supported: " + modbusPdu.getFunctionCode());
        }
        finally {
            ReferenceCountUtil.release((Object)modbusPdu);
        }
    }

    public ByteBuf encodeReadCoils(ReadCoilsRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        return buffer;
    }

    public ByteBuf encodeReadDiscreteInputs(ReadDiscreteInputsRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        return buffer;
    }

    public ByteBuf encodeReadHoldingRegisters(ReadHoldingRegistersRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        return buffer;
    }

    public ByteBuf encodeReadInputRegisters(ReadInputRegistersRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        return buffer;
    }

    public ByteBuf encodeWriteSingleCoil(WriteSingleCoilRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getValue());
        return buffer;
    }

    public ByteBuf encodeWriteSingleRegister(WriteSingleRegisterRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getValue());
        return buffer;
    }

    public ByteBuf encodeWriteMultipleCoils(WriteMultipleCoilsRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        int byteCount = request.getQuantity() / 8 + request.getQuantity() % 8;
        buffer.writeByte(byteCount);
        buffer.writeBytes(request.getValues(), byteCount);
        return buffer;
    }

    public ByteBuf encodeWriteMultipleRegisters(WriteMultipleRegistersRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getQuantity());
        int byteCount = request.getQuantity() * 2;
        buffer.writeByte(byteCount);
        buffer.writeBytes(request.getValues(), byteCount);
        return buffer;
    }

    public ByteBuf encodeMaskWriteRegister(MaskWriteRegisterRequest request, ByteBuf buffer) {
        buffer.writeByte(request.getFunctionCode().getCode());
        buffer.writeShort(request.getAddress());
        buffer.writeShort(request.getAndMask());
        buffer.writeShort(request.getOrMask());
        return buffer;
    }
}

