/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.strictmachine.dsl;

import com.digitalpetri.strictmachine.Fsm;
import com.digitalpetri.strictmachine.StrictMachine;
import com.digitalpetri.strictmachine.dsl.ActionFromBuilder;
import com.digitalpetri.strictmachine.dsl.ActionToBuilder;
import com.digitalpetri.strictmachine.dsl.Transition;
import com.digitalpetri.strictmachine.dsl.TransitionAction;
import com.digitalpetri.strictmachine.dsl.TransitionBuilder;
import com.digitalpetri.strictmachine.dsl.ViaBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsmBuilder<S extends Enum<S>, E> {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final List<Transition<S, E>> transitions = new ArrayList<Transition<S, E>>();
    private final List<TransitionAction<S, E>> transitionActions = new ArrayList<TransitionAction<S, E>>();
    private final Logger logger;
    private final Executor executor;

    public FsmBuilder() {
        this(EXECUTOR_SERVICE, StrictMachine.class.getName());
    }

    public FsmBuilder(Executor executor, String loggerName) {
        this.executor = executor;
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public TransitionBuilder<S, E> when(S state) {
        return new TransitionBuilder<S, E>(state, this.transitions, this.transitionActions);
    }

    public ViaBuilder<S, E> onInternalTransition(S state) {
        return this.onTransitionFrom(state).to(state);
    }

    public ActionToBuilder<S, E> onTransitionTo(S state) {
        return this.onTransitionTo(s -> Objects.equals(s, state));
    }

    public ActionToBuilder<S, E> onTransitionTo(Predicate<S> filter) {
        return new ActionToBuilder<S, E>(filter, this.transitionActions);
    }

    public ActionFromBuilder<S, E> onTransitionFrom(S state) {
        return this.onTransitionFrom(s -> Objects.equals(s, state));
    }

    public ActionFromBuilder<S, E> onTransitionFrom(Predicate<S> filter) {
        return new ActionFromBuilder<S, E>(filter, this.transitionActions);
    }

    public void addTransition(Transition<S, E> transition) {
        this.transitions.add(transition);
    }

    public void addTransitionAction(TransitionAction<S, E> transitionAction) {
        this.transitionActions.add(transitionAction);
    }

    public Fsm<S, E> build(S initialState) {
        return new StrictMachine<S, E>(this.logger, this.executor, initialState, new ArrayList<Transition<S, E>>(this.transitions), new ArrayList<TransitionAction<S, E>>(this.transitionActions));
    }
}

