/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.gradle.spotless.BiomeStepConfig;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.npm.EslintConfig;
import com.diffplug.spotless.npm.EslintFormatterStep;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Project;

public class JavascriptExtension
extends FormatExtension {
    static final String NAME = "javascript";
    private static final String DEFAULT_PRETTIER_JS_PARSER = "babel";
    private static final ImmutableList<String> PRETTIER_JS_PARSERS = ImmutableList.of((Object)"babel", (Object)"babel-flow", (Object)"flow");

    @Inject
    public JavascriptExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public JavascriptEslintConfig eslint() {
        return this.eslint(EslintFormatterStep.defaultDevDependenciesForTypescript());
    }

    public JavascriptEslintConfig eslint(String version) {
        return this.eslint(EslintFormatterStep.defaultDevDependenciesTypescriptWithEslint((String)version));
    }

    public JavascriptEslintConfig eslint(Map<String, String> devDependencies) {
        JavascriptEslintConfig eslint = new JavascriptEslintConfig(devDependencies);
        this.addStep(eslint.createStep());
        return eslint;
    }

    @Override
    public FormatExtension.PrettierConfig prettier() {
        return this.prettier(PrettierFormatterStep.defaultDevDependencies());
    }

    @Override
    public FormatExtension.PrettierConfig prettier(String version) {
        return this.prettier(PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)version));
    }

    @Override
    public FormatExtension.PrettierConfig prettier(Map<String, String> devDependencies) {
        JavascriptPrettierConfig prettierConfig = new JavascriptPrettierConfig(devDependencies);
        this.addStep(((FormatExtension.PrettierConfig)prettierConfig).createStep());
        return prettierConfig;
    }

    public BiomeJs biome() {
        return this.biome(null);
    }

    public BiomeJs biome(String version) {
        BiomeJs biomeConfig = new BiomeJs(version);
        this.addStep(biomeConfig.createStep());
        return biomeConfig;
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public class JavascriptEslintConfig
    extends EslintBaseConfig<JavascriptEslintConfig> {
        public JavascriptEslintConfig(Map<String, String> devDependencies) {
            super(JavascriptExtension.this.getProject(), JavascriptExtension.this::replaceStep, devDependencies);
        }

        @Override
        public FormatterStep createStep() {
            Project project = JavascriptExtension.this.getProject();
            return EslintFormatterStep.create((Map)this.devDependencies, (Provisioner)JavascriptExtension.this.provisioner(), (File)project.getProjectDir(), (File)((File)project.getLayout().getBuildDirectory().getAsFile().get()), (File)this.npmModulesCacheOrNull(), (NpmPathResolver)new NpmPathResolver(this.npmFileOrNull(), this.nodeFileOrNull(), this.npmrcFileOrNull(), Arrays.asList(project.getProjectDir(), project.getRootDir())), (EslintConfig)this.eslintConfig());
        }

        protected EslintConfig eslintConfig() {
            return new EslintConfig(this.configFilePath != null ? JavascriptExtension.this.getProject().file(this.configFilePath) : null, this.configJs);
        }
    }

    public class JavascriptPrettierConfig
    extends FormatExtension.PrettierConfig {
        JavascriptPrettierConfig(Map<String, String> devDependencies) {
            super(devDependencies);
        }

        @Override
        protected FormatterStep createStep() {
            this.fixParserToJavascript();
            return super.createStep();
        }

        private void fixParserToJavascript() {
            if (this.prettierConfig == null) {
                this.prettierConfig = Map.of("parser", JavascriptExtension.DEFAULT_PRETTIER_JS_PARSER);
            } else {
                Object currentParser = this.prettierConfig.get("parser");
                if (PRETTIER_JS_PARSERS.contains((Object)String.valueOf(currentParser))) {
                    JavascriptExtension.this.getProject().getLogger().debug("Already javascript parser set, not overriding.");
                } else {
                    this.prettierConfig.put("parser", JavascriptExtension.DEFAULT_PRETTIER_JS_PARSER);
                    if (currentParser != null) {
                        JavascriptExtension.this.getProject().getLogger().warn("Overriding parser option to '{}'. (Was set to '{}'.) Set it to another js parser if you have problems with '{}'.", new Object[]{JavascriptExtension.DEFAULT_PRETTIER_JS_PARSER, currentParser, JavascriptExtension.DEFAULT_PRETTIER_JS_PARSER});
                    }
                }
            }
        }
    }

    public class BiomeJs
    extends BiomeStepConfig<BiomeJs> {
        public BiomeJs(String version) {
            super(JavascriptExtension.this.getProject(), JavascriptExtension.this::replaceStep, version);
        }

        @Override
        protected String getLanguage() {
            return "js?";
        }

        @Override
        protected BiomeJs getThis() {
            return this;
        }
    }

    public static abstract class EslintBaseConfig<T extends EslintBaseConfig<?>>
    extends FormatExtension.NpmStepConfig<EslintBaseConfig<T>> {
        Map<String, String> devDependencies = new LinkedHashMap<String, String>();
        @Nullable
        Object configFilePath;
        @Nullable
        String configJs;

        protected EslintBaseConfig(Project project, Consumer<FormatterStep> replaceStep, Map<String, String> devDependencies) {
            super(project, replaceStep);
            this.devDependencies.putAll(Objects.requireNonNull(devDependencies));
        }

        protected T devDependencies(Map<String, String> devDependencies) {
            this.devDependencies.putAll(devDependencies);
            this.replaceStep();
            return (T)this;
        }

        public T configJs(String configJs) {
            this.configJs = Objects.requireNonNull(configJs);
            this.replaceStep();
            return (T)this;
        }

        public T configFile(Object configFilePath) {
            this.configFilePath = Objects.requireNonNull(configFilePath);
            this.replaceStep();
            return (T)this;
        }
    }
}

