/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.markdown.FlexmarkConfig;
import com.diffplug.spotless.markdown.FlexmarkStep;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class FlexmarkExtension
extends FormatExtension {
    static final String NAME = "flexmark";

    @Inject
    public FlexmarkExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public FlexmarkFormatterConfig flexmark() {
        return this.flexmark(FlexmarkStep.defaultVersion());
    }

    public FlexmarkFormatterConfig flexmark(String version) {
        return new FlexmarkFormatterConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public class FlexmarkFormatterConfig {
        private final String version;
        private final FlexmarkConfig config = new FlexmarkConfig();

        FlexmarkFormatterConfig(String version) {
            this.version = Objects.requireNonNull(version);
            FlexmarkExtension.this.addStep(this.createStep());
        }

        public FlexmarkFormatterConfig emulationProfile(String emulationProfile) {
            this.config.setEmulationProfile(emulationProfile);
            return this;
        }

        public FlexmarkFormatterConfig pegdownExtensions(int pegdownExtensions) {
            this.config.setPegdownExtensions(List.of(Integer.toString(pegdownExtensions)));
            return this;
        }

        public FlexmarkFormatterConfig pegdownExtensions(String ... pegdownExtensions) {
            this.config.setPegdownExtensions(List.of(pegdownExtensions));
            return this;
        }

        public FlexmarkFormatterConfig extensions(String ... extensions) {
            this.config.setExtensions(List.of(extensions));
            return this;
        }

        private FormatterStep createStep() {
            return FlexmarkStep.create((String)this.version, (Provisioner)FlexmarkExtension.this.provisioner(), (FlexmarkConfig)this.config);
        }
    }
}

