/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.JvmLang;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import com.diffplug.spotless.extra.groovy.GrEclipseFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.ImportOrderStep;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.util.GradleVersion;

public class GroovyExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense,
JvmLang {
    static final String NAME = "groovy";
    boolean excludeJava = false;

    @Inject
    public GroovyExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public void excludeJava() {
        this.excludeJava(true);
    }

    public void excludeJava(boolean excludeJava) {
        this.excludeJava = excludeJava;
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "(package|import|public|class|module) ");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "(package|import|public|class|module) ");
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.forGroovy().createFrom(importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.forGroovy().createFrom(this.getProject().file(importOrderFile)));
    }

    public GrEclipseConfig greclipse() {
        return this.greclipse(GrEclipseFormatterStep.defaultVersion());
    }

    public GrEclipseConfig greclipse(String version) {
        return new GrEclipseConfig(version, this);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            String message = "You must either specify 'target' manually or apply the 'groovy' plugin.";
            if (!this.getProject().getPlugins().hasPlugin(GroovyBasePlugin.class)) {
                throw new GradleException("You must either specify 'target' manually or apply the 'groovy' plugin.");
            }
            this.target = this.getSources(this.getProject(), "You must either specify 'target' manually or apply the 'groovy' plugin.", sourceSet -> {
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
                    return (SourceDirectorySet)sourceSet.getExtensions().getByType(GroovySourceDirectorySet.class);
                }
                GroovySourceSet groovySourceSet = (GroovySourceSet)new DslObject(sourceSet).getConvention().getPlugin(GroovySourceSet.class);
                return groovySourceSet.getGroovy();
            }, (Spec<? super File>)((Spec)file -> {
                String name = file.getName();
                if (this.excludeJava) {
                    return name.endsWith(".groovy");
                }
                return name.endsWith(".groovy") || name.endsWith(".java");
            }));
        } else if (this.excludeJava) {
            throw new IllegalArgumentException("'excludeJava' is not supported in combination with a custom 'target'.");
        }
        this.steps.replaceAll(step -> {
            if (this.isLicenseHeaderStep((FormatterStep)step)) {
                return step.filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
            }
            return step;
        });
        super.setupTask(task);
    }

    public static class GrEclipseConfig {
        private final EquoBasedStepBuilder builder;
        private final FormatExtension extension;

        GrEclipseConfig(String version, FormatExtension extension) {
            this.extension = extension;
            this.builder = GrEclipseFormatterStep.createBuilder((Provisioner)extension.provisioner());
            this.builder.setVersion(version);
            extension.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = this.extension.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            this.extension.replaceStep(this.builder.build());
        }

        public GrEclipseConfig withP2Mirrors(Map<String, String> mirrors) {
            this.builder.setP2Mirrors(mirrors);
            this.extension.replaceStep(this.builder.build());
            return this;
        }
    }
}

