/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializableFileFilter;
import com.diffplug.spotless.extra.java.EclipseFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import com.diffplug.spotless.java.ImportOrderStep;
import com.diffplug.spotless.java.RemoveUnusedImportsStep;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class JavaExtension
extends FormatExtension {
    static final String NAME = "java";
    static final String LICENSE_HEADER_DELIMITER = "package ";

    public JavaExtension(SpotlessExtension rootExtension) {
        super(rootExtension);
    }

    public void licenseHeader(String licenseHeader) {
        this.licenseHeader(licenseHeader, LICENSE_HEADER_DELIMITER);
    }

    public void licenseHeaderFile(Object licenseHeaderFile) {
        this.licenseHeaderFile(licenseHeaderFile, LICENSE_HEADER_DELIMITER);
    }

    @Deprecated
    public void importOrder(List<String> importOrder) {
        this.getProject().getLogger().warn(StringPrinter.buildStringFromLines((String[])new String[]{"'importOrder([x, y, z])' is deprecated.", "Use 'importOrder x, y, z' instead.", "For details see https://github.com/diffplug/spotless/tree/master/plugin-gradle#applying-to-java-source"}));
        this.addStep(ImportOrderStep.createFromOrder(importOrder));
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.createFromOrder((String[])importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.createFromFile((File)this.getProject().file(importOrderFile)));
    }

    @Deprecated
    public void eclipseFormatFile(Object eclipseFormatFile) {
        this.eclipseFormatFile(EclipseFormatterStep.defaultVersion(), eclipseFormatFile);
    }

    @Deprecated
    public void eclipseFormatFile(String eclipseVersion, Object eclipseFormatFile) {
        Objects.requireNonNull(eclipseVersion, "eclipseVersion");
        Objects.requireNonNull(eclipseFormatFile, "eclipseFormatFile");
        this.getProject().getLogger().warn(StringPrinter.buildStringFromLines((String[])new String[]{"'eclipseFormatFile [version] <file>' is deprecated.", "Use 'eclipse([version]).configFile(<file>)' instead.", "For details see https://github.com/diffplug/spotless/tree/master/plugin-gradle#applying-to-java-source"}));
        this.eclipse(eclipseVersion).configFile(eclipseFormatFile);
    }

    public void removeUnusedImports() {
        this.addStep(RemoveUnusedImportsStep.create((Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public GoogleJavaFormatConfig googleJavaFormat() {
        return this.googleJavaFormat(GoogleJavaFormatStep.defaultVersion());
    }

    public GoogleJavaFormatConfig googleJavaFormat(String version) {
        Objects.requireNonNull(version);
        return new GoogleJavaFormatConfig(version);
    }

    public EclipseConfig eclipse() {
        return this.eclipse(EclipseFormatterStep.defaultVersion());
    }

    public EclipseConfig eclipse(String version) {
        return new EclipseConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must apply the java plugin before the spotless plugin if you are using the java extension.");
            }
            ConfigurableFileCollection union = this.getProject().files(new Object[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union = union.plus((FileCollection)sourceSet.getAllJava());
            }
            this.target = union;
        }
        this.steps.replaceAll(step -> {
            if (LicenseHeaderStep.name().equals(step.getName())) {
                return step.filterByFile(SerializableFileFilter.skipFilesNamed((String[])new String[]{"package-info.java"}));
            }
            return step;
        });
        super.setupTask(task);
    }

    public class EclipseConfig {
        final String version;
        Object[] configFiles = new Object[0];

        EclipseConfig(String version) {
            this.version = Objects.requireNonNull(version);
            JavaExtension.this.addStep(this.createStep());
        }

        public void configFile(Object ... configFiles) {
            this.configFiles = PluginGradlePreconditions.requireElementsNonNull(configFiles);
            JavaExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            Project project = JavaExtension.this.getProject();
            return EclipseFormatterStep.create((String)this.version, (Iterable)project.files(this.configFiles).getFiles(), (Provisioner)GradleProvisioner.fromProject(project));
        }
    }

    public class GoogleJavaFormatConfig {
        final String version;
        String style;

        GoogleJavaFormatConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = GoogleJavaFormatStep.defaultStyle();
            JavaExtension.this.addStep(this.createStep());
        }

        public void style(String style) {
            this.style = Objects.requireNonNull(style);
            JavaExtension.this.replaceStep(this.createStep());
        }

        public void aosp() {
            this.style("AOSP");
        }

        private FormatterStep createStep() {
            Project project = JavaExtension.this.getProject();
            return GoogleJavaFormatStep.create((String)this.version, (String)this.style, (Provisioner)GradleProvisioner.fromProject(project));
        }
    }
}

