/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.wtp.EclipseWtpFormatterStep;
import com.diffplug.spotless.generic.EndWithNewlineStep;
import com.diffplug.spotless.generic.IndentStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.generic.ReplaceRegexStep;
import com.diffplug.spotless.generic.ReplaceStep;
import com.diffplug.spotless.generic.TrimTrailingWhitespaceStep;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import groovy.lang.Closure;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public class FormatExtension {
    final SpotlessExtension root;
    boolean paddedCell = false;
    LineEnding lineEndings;
    Charset encoding;
    final FormatExceptionPolicyStrict exceptionPolicy = new FormatExceptionPolicyStrict();
    protected FileCollection target;
    protected FileCollection targetExclude;
    protected final List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private Serializable globalState = new NeverUpToDateBetweenRuns();

    public FormatExtension(SpotlessExtension root) {
        this.root = Objects.requireNonNull(root);
    }

    private String formatName() {
        for (Map.Entry<String, FormatExtension> entry : this.root.formats.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("This format is not contained by any SpotlessExtension.");
    }

    public void paddedCell() {
        this.paddedCell(true);
    }

    public void paddedCell(boolean paddedCell) {
        this.paddedCell = paddedCell;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings == null ? this.root.getLineEndings() : this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding == null ? this.root.getEncoding() : this.encoding;
    }

    public void setEncoding(String name) {
        this.setEncoding(Charset.forName(Objects.requireNonNull(name)));
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void ignoreErrorForStep(String stepName) {
        this.exceptionPolicy.excludeStep(Objects.requireNonNull(stepName));
    }

    public void ignoreErrorForPath(String relativePath) {
        this.exceptionPolicy.excludePath(Objects.requireNonNull(relativePath));
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void target(Object ... targets) {
        this.target = this.parseTargets(targets);
    }

    public void targetExclude(Object ... targets) {
        this.targetExclude = this.parseTargets(targets);
    }

    private FileCollection parseTargets(Object[] targets) {
        PluginGradlePreconditions.requireElementsNonNull(targets);
        if (targets.length == 0) {
            return this.getProject().files(new Object[0]);
        }
        if (targets.length == 1) {
            return this.parseTarget(targets[0]);
        }
        if (Stream.of(targets).allMatch(o -> o instanceof String)) {
            return this.parseTarget(Arrays.asList(targets));
        }
        ConfigurableFileCollection union = this.getProject().files(new Object[0]);
        for (Object target : targets) {
            union = union.plus(this.parseTarget(target));
        }
        return union;
    }

    protected FileCollection parseTarget(Object target) {
        if (target instanceof FileCollection) {
            return (FileCollection)target;
        }
        if (target instanceof String || target instanceof List && ((List)target).stream().allMatch(o -> o instanceof String)) {
            File dir = this.getProject().getProjectDir();
            ArrayList<String> excludes = new ArrayList<String>();
            excludes.add(".git");
            if (this.getProject() == this.getProject().getRootProject()) {
                excludes.add(".gradle");
            }
            FormatExtension.relativizeIfSubdir(excludes, dir, this.getProject().getBuildDir());
            for (Project subproject : this.getProject().getSubprojects()) {
                FormatExtension.relativizeIfSubdir(excludes, dir, subproject.getBuildDir());
            }
            if (target instanceof String) {
                return (FileCollection)this.getProject().fileTree((Object)dir).include(new String[]{(String)target}).exclude(excludes);
            }
            return (FileCollection)this.getProject().fileTree((Object)dir).include((Iterable)((List)target)).exclude(excludes);
        }
        return this.getProject().files(new Object[]{target});
    }

    private static void relativizeIfSubdir(List<String> relativePaths, File root, File dest) {
        String relativized = FormatExtension.relativize(root, dest);
        if (relativized != null) {
            relativePaths.add(relativized);
        }
    }

    @Nullable
    static String relativize(File root, File dest) {
        String rootPath = root.getAbsolutePath();
        String destPath = dest.getAbsolutePath();
        if (!destPath.startsWith(rootPath)) {
            return null;
        }
        return destPath.substring(rootPath.length());
    }

    public void addStep(FormatterStep newStep) {
        Objects.requireNonNull(newStep);
        int existingIdx = this.getExistingStepIdx(newStep.getName());
        if (existingIdx != -1) {
            throw new GradleException("Multiple steps with name '" + newStep.getName() + "' for spotless format '" + this.formatName() + "'");
        }
        this.steps.add(newStep);
    }

    @Deprecated
    @Nullable
    protected FormatterStep getExistingStep(String stepName) {
        return this.steps.stream().filter(step -> stepName.equals(step.getName())).findFirst().orElse(null);
    }

    protected int getExistingStepIdx(String stepName) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.steps.get(i).getName().equals(stepName)) continue;
            return i;
        }
        return -1;
    }

    protected void replaceStep(FormatterStep replacementStep) {
        int existingIdx = this.getExistingStepIdx(replacementStep.getName());
        if (existingIdx == -1) {
            throw new GradleException("Cannot replace step '" + replacementStep.getName() + "' for spotless format '" + this.formatName() + "' because it hasn't been added yet.");
        }
        this.steps.set(existingIdx, replacementStep);
    }

    public void clearSteps() {
        this.steps.clear();
    }

    public void bumpThisNumberIfACustomStepChanges(int number) {
        this.globalState = Integer.valueOf(number);
    }

    public void customLazy(String name, ThrowingEx.Supplier<FormatterFunc> formatterSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(formatterSupplier, "formatterSupplier");
        this.addStep(FormatterStep.createLazy((String)name, () -> this.globalState, unusedState -> (FormatterFunc)formatterSupplier.get()));
    }

    public void customLazyGroovy(String name, ThrowingEx.Supplier<Closure<String>> formatterSupplier) {
        Objects.requireNonNull(formatterSupplier, "formatterSupplier");
        this.customLazy(name, (ThrowingEx.Supplier<FormatterFunc>)((ThrowingEx.Supplier)() -> arg_0 -> ((Closure)((Closure)formatterSupplier.get())).call(arg_0)));
    }

    public void custom(String name, Closure<String> formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.custom(name, arg_0 -> formatter.call(arg_0));
    }

    public void custom(String name, FormatterFunc formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.customLazy(name, (ThrowingEx.Supplier<FormatterFunc>)((ThrowingEx.Supplier)() -> formatter));
    }

    public void replace(String name, CharSequence original, CharSequence after) {
        this.addStep(ReplaceStep.create((String)name, (CharSequence)original, (CharSequence)after));
    }

    public void replaceRegex(String name, String regex, String replacement) {
        this.addStep(ReplaceRegexStep.create((String)name, (String)regex, (String)replacement));
    }

    public void trimTrailingWhitespace() {
        this.addStep(TrimTrailingWhitespaceStep.create());
    }

    public void endWithNewline() {
        this.addStep(EndWithNewlineStep.create());
    }

    public void indentWithSpaces(int numSpacesPerTab) {
        this.addStep(IndentStep.Type.SPACE.create(numSpacesPerTab));
    }

    public void indentWithSpaces() {
        this.addStep(IndentStep.Type.SPACE.create());
    }

    public void indentWithTabs(int tabToSpaces) {
        this.addStep(IndentStep.Type.TAB.create(tabToSpaces));
    }

    public void indentWithTabs() {
        this.addStep(IndentStep.Type.TAB.create());
    }

    public LicenseHeaderConfig licenseHeader(String licenseHeader, String delimiter) {
        LicenseStringHeaderConfig config = new LicenseStringHeaderConfig(delimiter, licenseHeader);
        this.addStep(((LicenseHeaderConfig)config).createStep());
        return config;
    }

    public LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile, String delimiter) {
        LicenseFileHeaderConfig config = new LicenseFileHeaderConfig(delimiter, licenseHeaderFile);
        this.addStep(((LicenseHeaderConfig)config).createStep());
        return config;
    }

    public PrettierConfig prettier() {
        PrettierConfig prettierConfig = new PrettierConfig();
        this.addStep(prettierConfig.createStep());
        return prettierConfig;
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type) {
        return this.eclipseWtp(type, EclipseWtpFormatterStep.defaultVersion());
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type, String version) {
        return new EclipseWtpConfig(type, version);
    }

    protected void setupTask(SpotlessTask task) {
        task.setPaddedCell(this.paddedCell);
        task.setEncoding(this.getEncoding().name());
        task.setExceptionPolicy((FormatExceptionPolicy)this.exceptionPolicy);
        if (this.targetExclude == null) {
            task.setTarget((Iterable<File>)this.target);
        } else {
            task.setTarget((Iterable<File>)this.target.minus(this.targetExclude));
        }
        task.setSteps(this.steps);
        task.setLineEndingsPolicy(this.getLineEndings().createPolicy(this.getProject().getProjectDir(), () -> task.target));
    }

    protected Project getProject() {
        return this.root.project;
    }

    public class EclipseWtpConfig {
        private final EclipseBasedStepBuilder builder;

        EclipseWtpConfig(EclipseWtpFormatterStep type, String version) {
            this.builder = type.createBuilder(GradleProvisioner.fromProject(FormatExtension.this.getProject()));
            this.builder.setVersion(version);
            FormatExtension.this.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = FormatExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            FormatExtension.this.replaceStep(this.builder.build());
        }
    }

    public class PrettierConfig
    extends NpmStepConfig<PrettierConfig> {
        @Nullable
        protected Object prettierConfigFile;
        @Nullable
        protected Map<String, Object> prettierConfig;

        public PrettierConfig configFile(Object prettierConfigFile) {
            this.prettierConfigFile = prettierConfigFile;
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public PrettierConfig config(Map<String, Object> prettierConfig) {
            this.prettierConfig = new TreeMap<String, Object>(prettierConfig);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        @Override
        FormatterStep createStep() {
            Project project = FormatExtension.this.getProject();
            return PrettierFormatterStep.create((Provisioner)GradleProvisioner.fromProject(project), (File)project.getBuildDir(), (File)this.npmFileOrNull(), (com.diffplug.spotless.npm.PrettierConfig)new com.diffplug.spotless.npm.PrettierConfig(this.prettierConfigFile != null ? project.file(this.prettierConfigFile) : null, this.prettierConfig));
        }
    }

    public abstract class NpmStepConfig<T extends NpmStepConfig<?>> {
        @Nullable
        protected Object npmFile;

        public T npmExecutable(Object npmFile) {
            this.npmFile = npmFile;
            FormatExtension.this.replaceStep(this.createStep());
            return (T)this;
        }

        File npmFileOrNull() {
            return this.npmFile != null ? FormatExtension.this.getProject().file(this.npmFile) : null;
        }

        abstract FormatterStep createStep();
    }

    class LicenseFileHeaderConfig
    extends LicenseHeaderConfig {
        private Object headerFile;

        LicenseFileHeaderConfig(String delimiter, Object headerFile) {
            super(delimiter);
            this.headerFile = Objects.requireNonNull(headerFile, "headerFile");
        }

        @Override
        FormatterStep createStep() {
            return LicenseHeaderStep.createFromFile((File)FormatExtension.this.getProject().file(this.headerFile), (Charset)FormatExtension.this.getEncoding(), (String)this.delimiter, (String)this.yearSeparator);
        }
    }

    class LicenseStringHeaderConfig
    extends LicenseHeaderConfig {
        private String header;

        LicenseStringHeaderConfig(String delimiter, String header) {
            super(delimiter);
            this.header = Objects.requireNonNull(header, "header");
        }

        @Override
        FormatterStep createStep() {
            return LicenseHeaderStep.createFromHeader((String)this.header, (String)this.delimiter, (String)this.yearSeparator);
        }
    }

    abstract class LicenseHeaderConfig {
        String delimiter;
        String yearSeparator = LicenseHeaderStep.defaultYearDelimiter();

        public LicenseHeaderConfig(String delimiter) {
            this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
        }

        public LicenseHeaderConfig delimiter(String delimiter) {
            this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig yearSeparator(String yearSeparator) {
            this.yearSeparator = Objects.requireNonNull(yearSeparator, "yearSeparator");
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        abstract FormatterStep createStep();
    }

    static class NeverUpToDateBetweenRuns
    extends LazyForwardingEquality<Integer> {
        private static final long serialVersionUID = 1L;
        private static final Random RANDOM = new Random();

        NeverUpToDateBetweenRuns() {
        }

        protected Integer calculateState() throws Exception {
            return RANDOM.nextInt();
        }
    }
}

