/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.incremental;

import com.diffplug.common.annotations.VisibleForTesting;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.maven.incremental.FileIndex;
import com.diffplug.spotless.maven.incremental.FileIndexConfig;
import com.diffplug.spotless.maven.incremental.PluginFingerprint;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

class IndexBasedChecker
implements UpToDateChecker {
    private final FileIndex index;
    private final Log log;

    @VisibleForTesting
    IndexBasedChecker(FileIndex index, Log log) {
        this.index = index;
        this.log = log;
    }

    static IndexBasedChecker create(MavenProject project, Path indexFile, Iterable<Formatter> formatters, Log log) {
        PluginFingerprint pluginFingerprint = PluginFingerprint.from(project, formatters);
        FileIndexConfig indexConfig = new FileIndexConfig(project, indexFile, pluginFingerprint);
        FileIndex fileIndex = FileIndex.read(indexConfig, log);
        return new IndexBasedChecker(fileIndex, log);
    }

    @Override
    public boolean isUpToDate(Path file) {
        Instant storedLastModifiedTime = this.index.getLastModifiedTime(file);
        return Objects.equals(storedLastModifiedTime, IndexBasedChecker.lastModifiedTime(file));
    }

    @Override
    public void setUpToDate(Path file) {
        Instant lastModified = IndexBasedChecker.lastModifiedTime(file);
        if (Instant.MIN.equals(lastModified) || Instant.MAX.equals(lastModified)) {
            this.log.warn((CharSequence)("File " + String.valueOf(file) + " has an approximated last modified time of " + String.valueOf(lastModified) + ". It will not be recorded in the up-to-date index."));
            return;
        }
        this.index.setLastModifiedTime(file, lastModified);
    }

    @Override
    public void close() {
        this.index.write();
    }

    private static Instant lastModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to get last modified date for " + String.valueOf(path), e);
        }
    }
}

