/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.json.JacksonConfig;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public abstract class AJacksonFormatterFunc
implements FormatterFunc {
    private final JacksonConfig jacksonConfig;

    protected AJacksonFormatterFunc(JacksonConfig jacksonConfig) {
        this.jacksonConfig = jacksonConfig;
    }

    @Override
    public String apply(String input) throws Exception {
        ObjectMapper objectMapper = this.makeObjectMapper();
        return this.format(objectMapper, input);
    }

    protected String format(ObjectMapper objectMapper, String input) throws IllegalArgumentException, IOException {
        try {
            Object objectNode = objectMapper.readValue(input, this.inferType(input));
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to format. input='" + input + "'", e);
        }
    }

    protected abstract Class<?> inferType(String var1);

    protected abstract JsonFactory makeJsonFactory();

    protected ObjectMapper makeObjectMapper() {
        JsonFactory jsonFactory = this.makeJsonFactory();
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        objectMapper.setDefaultPrettyPrinter(this.makePrettyPrinter());
        this.jacksonConfig.getFeatureToToggle().forEach((rawFeature, toggle) -> {
            SerializationFeature feature = SerializationFeature.valueOf((String)rawFeature);
            objectMapper.configure(feature, toggle.booleanValue());
        });
        return objectMapper;
    }

    protected PrettyPrinter makePrettyPrinter() {
        return new DefaultPrettyPrinter();
    }
}

