/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Lint;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ReplaceRegexStep {
    private ReplaceRegexStep() {
    }

    public static FormatterStep create(String name, String regex, String replacement) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(regex, "regex");
        Objects.requireNonNull(replacement, "replacement");
        return FormatterStep.createLazy(name, () -> new State(Pattern.compile(regex, 9), replacement), State::toFormatter);
    }

    public static FormatterStep lint(String name, String regex, String lintDetail) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(regex, "regex");
        Objects.requireNonNull(lintDetail, "lintDetail");
        return FormatterStep.createLazy(name, () -> new LintState(Pattern.compile(regex, 9), name, lintDetail), LintState::toLinter);
    }

    private static final class LintState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern regex;
        private final String ruleId;
        private final String lintDetail;

        LintState(Pattern regex, String ruleId, String lintDetail) {
            this.regex = regex;
            this.ruleId = ruleId;
            this.lintDetail = lintDetail;
        }

        FormatterFunc toLinter() {
            return new FormatterFunc(){

                @Override
                public String apply(String raw) {
                    return raw;
                }

                @Override
                public List<Lint> lint(String raw, File file) {
                    ArrayList<Lint> lints = new ArrayList<Lint>();
                    Matcher matcher = regex.matcher(raw);
                    while (matcher.find()) {
                        int line = 1 + (int)raw.codePoints().limit(matcher.start()).filter(c -> c == 10).count();
                        String errorCode = matcher.group(0).trim();
                        int firstNewline = errorCode.indexOf("\n");
                        if (firstNewline != -1) {
                            errorCode = errorCode.substring(0, firstNewline);
                        }
                        lints.add(Lint.atLine(line, errorCode, lintDetail));
                    }
                    return lints;
                }
            };
        }
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern regex;
        private final String replacement;

        State(Pattern regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
        }

        FormatterFunc toFormatter() {
            return raw -> this.regex.matcher(raw).replaceAll(this.replacement);
        }
    }
}

