/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.DelegateFormatterStep;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.OnMatch;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class FilterByContentPatternFormatterStep
extends DelegateFormatterStep {
    final OnMatch onMatch;
    final Pattern contentPattern;
    private static final long serialVersionUID = 2L;

    FilterByContentPatternFormatterStep(FormatterStep delegateStep, OnMatch onMatch, String contentPattern) {
        super(delegateStep);
        this.onMatch = onMatch;
        this.contentPattern = Pattern.compile(Objects.requireNonNull(contentPattern));
    }

    @Override
    @Nullable
    public String format(String raw, File file) throws Exception {
        Objects.requireNonNull(raw, "raw");
        Objects.requireNonNull(file, "file");
        if (this.contentPattern.matcher(raw).find() == (this.onMatch == OnMatch.INCLUDE)) {
            return this.delegateStep.format(raw, file);
        }
        return raw;
    }

    @Override
    public List<Lint> lint(String raw, File file) throws Exception {
        Objects.requireNonNull(raw, "raw");
        Objects.requireNonNull(file, "file");
        if (this.contentPattern.matcher(raw).find() == (this.onMatch == OnMatch.INCLUDE)) {
            return this.delegateStep.lint(raw, file);
        }
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterByContentPatternFormatterStep that = (FilterByContentPatternFormatterStep)o;
        return Objects.equals(this.delegateStep, that.delegateStep) && this.onMatch == that.onMatch && Objects.equals(this.contentPattern.pattern(), that.contentPattern.pattern());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delegateStep, this.onMatch, this.contentPattern.pattern()});
    }
}

