/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class FlexmarkStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VERSION = "0.64.8";
    private static final String MAVEN_COORDINATE = "com.vladsch.flexmark:flexmark-all:";
    public static final String NAME = "flexmark-java";
    private final JarState.Promised jarState;

    private FlexmarkStep(JarState.Promised jarState) {
        this.jarState = jarState;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return FlexmarkStep.create(FlexmarkStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.create(NAME, new FlexmarkStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + version, provisioner))), FlexmarkStep::equalityState, State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private State equalityState() {
        return new State(this.jarState.get());
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;

        State(JarState jarState) {
            this.jarState = jarState;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.markdown.FlexmarkFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(new Class[0]);
            return (FormatterFunc)constructor.newInstance(new Object[0]);
        }
    }
}

