/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.EncodingErrorMsg;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.ValuePerStep;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import javax.annotation.Nullable;

public class DirtyState {
    @Nullable
    private final byte[] canonicalBytes;
    static final DirtyState didNotConverge = new DirtyState(null);
    static final DirtyState isClean = new DirtyState(null);

    DirtyState(@Nullable byte[] canonicalBytes) {
        this.canonicalBytes = canonicalBytes;
    }

    public boolean isClean() {
        return this == isClean;
    }

    public boolean didNotConverge() {
        return this == didNotConverge;
    }

    byte[] canonicalBytes() {
        if (this.canonicalBytes == null) {
            throw new IllegalStateException("First make sure that {@code !isClean()} and {@code !didNotConverge()}");
        }
        return this.canonicalBytes;
    }

    public void writeCanonicalTo(File file) throws IOException {
        Files.write(file.toPath(), this.canonicalBytes(), new OpenOption[0]);
    }

    public void writeCanonicalTo(OutputStream out) throws IOException {
        out.write(this.canonicalBytes());
    }

    public static DirtyState clean() {
        return isClean;
    }

    public static DirtyState of(Formatter formatter, File file) throws IOException {
        return DirtyState.of(formatter, file, Files.readAllBytes(file.toPath()));
    }

    public static DirtyState of(Formatter formatter, File file, byte[] rawBytes) {
        return DirtyState.of(formatter, file, rawBytes, new String(rawBytes, formatter.getEncoding()));
    }

    public static DirtyState of(Formatter formatter, File file, byte[] rawBytes, String raw) {
        ValuePerStep<Throwable> valuePerStep = new ValuePerStep<Throwable>(formatter);
        DirtyState state = DirtyState.of(formatter, file, rawBytes, raw, valuePerStep);
        Formatter.legacyErrorBehavior(formatter, file, valuePerStep);
        return state;
    }

    static DirtyState of(Formatter formatter, File file, byte[] rawBytes, String raw, ValuePerStep<Throwable> exceptionPerStep) {
        String encodingError = EncodingErrorMsg.msg(raw, rawBytes, formatter.getEncoding());
        if (encodingError != null) {
            throw new IllegalArgumentException(encodingError);
        }
        String rawUnix = LineEnding.toUnix(raw);
        String formattedUnix = formatter.computeWithLint(rawUnix, file, exceptionPerStep);
        String formatted = formatter.computeLineEndings(formattedUnix, file);
        byte[] formattedBytes = formatted.getBytes(formatter.getEncoding());
        if (Arrays.equals(rawBytes, formattedBytes)) {
            return isClean;
        }
        String doubleFormattedUnix = formatter.computeWithLint(formattedUnix, file, exceptionPerStep);
        if (doubleFormattedUnix.equals(formattedUnix)) {
            return new DirtyState(formattedBytes);
        }
        PaddedCell cell = PaddedCell.check(formatter, file, rawUnix, exceptionPerStep);
        if (!cell.isResolvable()) {
            return didNotConverge;
        }
        String canonicalUnix = cell.canonical();
        String canonical = formatter.computeLineEndings(canonicalUnix, file);
        byte[] canonicalBytes = canonical.getBytes(formatter.getEncoding());
        if (!Arrays.equals(rawBytes, canonicalBytes)) {
            return new DirtyState(canonicalBytes);
        }
        return isClean;
    }
}

