/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FilterByContentPatternFormatterStep;
import com.diffplug.spotless.FilterByFileFormatterStep;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStepSerializationRoundtrip;
import com.diffplug.spotless.OnMatch;
import com.diffplug.spotless.SerializableFileFilter;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public interface FormatterStep
extends Serializable,
AutoCloseable {
    public String getName();

    @Nullable
    public String format(String var1, File var2) throws Exception;

    default public FormatterStep filterByContent(OnMatch onMatch, String contentPattern) {
        return new FilterByContentPatternFormatterStep(this, onMatch, contentPattern);
    }

    default public FormatterStep filterByFile(SerializableFileFilter filter) {
        return new FilterByFileFormatterStep(this, filter);
    }

    public static <RoundtripState extends Serializable, EqualityState extends Serializable> FormatterStep createLazy(String name, ThrowingEx.Supplier<RoundtripState> roundtripInit, SerializedFunction<RoundtripState, EqualityState> equalityFunc, SerializedFunction<EqualityState, FormatterFunc> formatterFunc) {
        return new FormatterStepSerializationRoundtrip<RoundtripState, EqualityState>(name, roundtripInit, equalityFunc, formatterFunc);
    }

    public static <RoundtripState extends Serializable, EqualityState extends Serializable> FormatterStep create(String name, RoundtripState roundTrip, SerializedFunction<RoundtripState, EqualityState> equalityFunc, SerializedFunction<EqualityState, FormatterFunc> formatterFunc) {
        return FormatterStep.createLazy(name, () -> roundTrip, equalityFunc, formatterFunc);
    }

    public static <State extends Serializable> FormatterStep createLazy(String name, ThrowingEx.Supplier<State> stateSupplier, SerializedFunction<State, FormatterFunc> stateToFormatter) {
        return FormatterStep.createLazy(name, stateSupplier, SerializedFunction.identity(), stateToFormatter);
    }

    public static <State extends Serializable> FormatterStep create(String name, State state, SerializedFunction<State, FormatterFunc> stateToFormatter) {
        Objects.requireNonNull(state, "state");
        return FormatterStep.createLazy(name, () -> state, stateToFormatter);
    }
}

