/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.scala;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import javax.annotation.Nullable;

public class ScalaFmtStep {
    static final String DEFAULT_VERSION = "3.7.3";
    private static final String DEFAULT_SCALA_MAJOR_VERSION = "2.13";
    static final String NAME = "scalafmt";
    static final String MAVEN_COORDINATE = "org.scalameta:scalafmt-core_";

    private ScalaFmtStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return ScalaFmtStep.create(ScalaFmtStep.defaultVersion(), ScalaFmtStep.defaultScalaMajorVersion(), provisioner, null);
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable File configFile) {
        return ScalaFmtStep.create(version, ScalaFmtStep.defaultScalaMajorVersion(), provisioner, configFile);
    }

    public static FormatterStep create(String version, @Nullable String scalaMajorVersion, Provisioner provisioner, @Nullable File configFile) {
        String finalScalaMajorVersion = scalaMajorVersion == null ? DEFAULT_SCALA_MAJOR_VERSION : scalaMajorVersion;
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(MAVEN_COORDINATE + finalScalaMajorVersion + ":" + version, provisioner), configFile), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static String defaultScalaMajorVersion() {
        return DEFAULT_SCALA_MAJOR_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final FileSignature configSignature;

        State(JarState jarState, @Nullable File configFile) throws IOException {
            this.jarState = jarState;
            this.configSignature = FileSignature.signAsList(configFile == null ? Collections.emptySet() : Collections.singleton(configFile));
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.scalafmt.ScalafmtFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(FileSignature.class);
            return (FormatterFunc)constructor.newInstance(this.configSignature);
        }
    }
}

