/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.DelegateFormatterStep;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.SerializableFileFilter;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;

final class FilterByFileFormatterStep
extends DelegateFormatterStep {
    private final SerializableFileFilter filter;
    private static final long serialVersionUID = 1L;

    FilterByFileFormatterStep(FormatterStep delegateStep, SerializableFileFilter filter) {
        super(delegateStep);
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    @Nullable
    public String format(String raw, File file) throws Exception {
        Objects.requireNonNull(raw, "raw");
        Objects.requireNonNull(file, "file");
        if (this.filter.accept(file)) {
            return this.delegateStep.format(raw, file);
        }
        return raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterByFileFormatterStep that = (FilterByFileFormatterStep)o;
        return Objects.equals(this.delegateStep, that.delegateStep) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.delegateStep, this.filter);
    }
}

