/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.java;

import com.diffplug.spotless.FormatterFunc;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.StringWrapper;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GoogleJavaFormatFormatterFunc
implements FormatterFunc {
    @Nonnull
    private final Formatter formatter;
    @Nonnull
    private final String version;
    @Nonnull
    private final JavaFormatterOptions.Style formatterStyle;
    private final boolean reflowStrings;

    public GoogleJavaFormatFormatterFunc(@Nonnull String version, @Nonnull String style, boolean reflowStrings) {
        this.version = Objects.requireNonNull(version);
        this.formatterStyle = JavaFormatterOptions.Style.valueOf((String)Objects.requireNonNull(style));
        this.reflowStrings = reflowStrings;
        this.formatter = new Formatter(JavaFormatterOptions.builder().style(this.formatterStyle).build());
    }

    @Override
    @Nonnull
    public String apply(@Nonnull String input) throws Exception {
        String formatted = this.formatter.formatSource(input);
        String removedUnused = RemoveUnusedImports.removeUnusedImports((String)formatted);
        String sortedImports = ImportOrderer.reorderImports((String)removedUnused, (JavaFormatterOptions.Style)JavaFormatterOptions.Style.GOOGLE);
        return this.reflowLongStrings(sortedImports);
    }

    private String reflowLongStrings(String input) throws FormatterException {
        if (this.reflowStrings) {
            return StringWrapper.wrap((String)input, (Formatter)this.formatter);
        }
        return input;
    }
}

