/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class PalantirJavaFormatStep {
    private static final String DEFAULT_STYLE = "PALANTIR";
    private static final String NAME = "palantir-java-format";
    private static final String MAVEN_COORDINATE = "com.palantir.javaformat:palantir-java-format:";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("palantir-java-format").add(8, "1.1.0").add(11, "2.28.0");

    private PalantirJavaFormatStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return PalantirJavaFormatStep.create(PalantirJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return PalantirJavaFormatStep.create(version, PalantirJavaFormatStep.defaultStyle(), provisioner);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(style, "style");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(MAVEN_COORDINATE + version, provisioner), version, style), State::createFormat);
    }

    public static String defaultVersion() {
        return JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static String defaultStyle() {
        return DEFAULT_STYLE;
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String formatterVersion;
        private final String style;

        State(JarState jarState, String formatterVersion) {
            this(jarState, formatterVersion, PalantirJavaFormatStep.DEFAULT_STYLE);
        }

        State(JarState jarState, String formatterVersion, String style) {
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = jarState;
            this.formatterVersion = formatterVersion;
            this.style = style;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.pjf.PalantirJavaFormatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.formatterVersion, (FormatterFunc)constructor.newInstance(this.style));
        }
    }
}

