/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public final class CleanthatJavaStep {
    private static final String NAME = "cleanthat";
    private static final String MAVEN_COORDINATE = "io.github.solven-eu.cleanthat:java";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("cleanthat").add(11, "2.13");

    private CleanthatJavaStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return CleanthatJavaStep.create(CleanthatJavaStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return CleanthatJavaStep.create(MAVEN_COORDINATE, version, CleanthatJavaStep.defaultSourceJdk(), CleanthatJavaStep.defaultMutators(), CleanthatJavaStep.defaultExcludedMutators(), CleanthatJavaStep.defaultIncludeDraft(), provisioner);
    }

    public static String defaultSourceJdk() {
        return "1.7";
    }

    public static List<String> defaultMutators() {
        return List.of("SafeAndConsensual");
    }

    public static List<String> defaultExcludedMutators() {
        return List.of();
    }

    public static boolean defaultIncludeDraft() {
        return false;
    }

    public static FormatterStep create(String groupArtifact, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft, Provisioner provisioner) {
        Objects.requireNonNull(groupArtifact, "groupArtifact");
        if (groupArtifact.chars().filter(ch -> ch == 58).count() != 1L) {
            throw new IllegalArgumentException("groupArtifact must be in the form 'groupId:artifactId'. it was: " + groupArtifact);
        }
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new JavaRefactorerState(NAME, groupArtifact, version, sourceJdkVersion, included, excluded, includeDraft, provisioner), JavaRefactorerState::createFormat);
    }

    public static String defaultVersion() {
        return JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static String defaultGroupArtifact() {
        return MAVEN_COORDINATE;
    }

    static final class JavaRefactorerState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final String stepName;
        final String version;
        final String sourceJdkVersion;
        final List<String> included;
        final List<String> excluded;
        final boolean includeDraft;

        JavaRefactorerState(String stepName, String version, Provisioner provisioner) throws IOException {
            this(stepName, CleanthatJavaStep.MAVEN_COORDINATE, version, CleanthatJavaStep.defaultSourceJdk(), CleanthatJavaStep.defaultMutators(), CleanthatJavaStep.defaultExcludedMutators(), CleanthatJavaStep.defaultIncludeDraft(), provisioner);
        }

        JavaRefactorerState(String stepName, String groupArtifact, String version, String sourceJdkVersion, List<String> included, List<String> excluded, boolean includeDraft, Provisioner provisioner) throws IOException {
            JVM_SUPPORT.assertFormatterSupported(version);
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = JarState.from(groupArtifact + ":" + version, provisioner);
            this.stepName = stepName;
            this.version = version;
            this.sourceJdkVersion = sourceJdkVersion;
            this.included = included;
            this.excluded = excluded;
            this.includeDraft = includeDraft;
        }

        FormatterFunc createFormat() {
            Method formatterMethod;
            Object formatter;
            ClassLoader classLoader = this.jarState.getClassLoader();
            try {
                Class<?> formatterClazz = classLoader.loadClass("com.diffplug.spotless.glue.java.JavaCleanthatRefactorerFunc");
                Constructor<?> formatterConstructor = formatterClazz.getConstructor(String.class, List.class, List.class, Boolean.TYPE);
                formatter = formatterConstructor.newInstance(this.sourceJdkVersion, this.included, this.excluded, this.includeDraft);
                formatterMethod = formatterClazz.getMethod("apply", String.class);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Issue executing the formatter", e);
            }
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, input -> (String)formatterMethod.invoke(formatter, input));
        }
    }
}

