/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.SerializableFileFilter;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class LicenseHeaderStep {
    final ThrowingEx.Supplier<String> headerLazy;
    final String delimiter;
    final String yearSeparator;
    final Supplier<YearMode> yearMode;
    private static final String NAME = "licenseHeader";
    private static final String DEFAULT_YEAR_DELIMITER = "-";
    private static final List<String> YEAR_TOKENS = Arrays.asList("$YEAR", "$today.year");
    private static final SerializableFileFilter UNSUPPORTED_JVM_FILES_FILTER = SerializableFileFilter.skipFilesNamed("package-info.java", "package-info.groovy", "module-info.java");
    public static final String spotlessSetLicenseHeaderYearsFromGitHistory = "spotlessSetLicenseHeaderYearsFromGitHistory";

    public static LicenseHeaderStep headerDelimiter(String header, String delimiter) {
        return LicenseHeaderStep.headerDelimiter(() -> header, delimiter);
    }

    public static LicenseHeaderStep headerDelimiter(ThrowingEx.Supplier<String> headerLazy, String delimiter) {
        return new LicenseHeaderStep(headerLazy, delimiter, DEFAULT_YEAR_DELIMITER, () -> YearMode.PRESERVE);
    }

    private LicenseHeaderStep(ThrowingEx.Supplier<String> headerLazy, String delimiter, String yearSeparator, Supplier<YearMode> yearMode) {
        this.headerLazy = Objects.requireNonNull(headerLazy);
        this.delimiter = Objects.requireNonNull(delimiter);
        this.yearSeparator = Objects.requireNonNull(yearSeparator);
        this.yearMode = Objects.requireNonNull(yearMode);
    }

    public LicenseHeaderStep withHeaderString(String header) {
        return this.withHeaderLazy(() -> header);
    }

    public LicenseHeaderStep withHeaderLazy(ThrowingEx.Supplier<String> headerLazy) {
        return new LicenseHeaderStep(headerLazy, this.delimiter, this.yearSeparator, this.yearMode);
    }

    public LicenseHeaderStep withDelimiter(String delimiter) {
        return new LicenseHeaderStep(this.headerLazy, delimiter, this.yearSeparator, this.yearMode);
    }

    public LicenseHeaderStep withYearSeparator(String yearSeparator) {
        return new LicenseHeaderStep(this.headerLazy, this.delimiter, yearSeparator, this.yearMode);
    }

    public LicenseHeaderStep withYearMode(YearMode yearMode) {
        return this.withYearModeLazy(() -> yearMode);
    }

    public LicenseHeaderStep withYearModeLazy(Supplier<YearMode> yearMode) {
        return new LicenseHeaderStep(this.headerLazy, this.delimiter, this.yearSeparator, yearMode);
    }

    public FormatterStep build() {
        if (this.yearMode.get() == YearMode.SET_FROM_GIT) {
            return FormatterStep.createNeverUpToDateLazy(LicenseHeaderStep.name(), () -> {
                boolean updateYear = false;
                Runtime runtime = new Runtime(this.headerLazy.get(), this.delimiter, this.yearSeparator, updateYear);
                return FormatterFunc.needsFile((x$0, x$1) -> runtime.setLicenseHeaderYearsFromGitHistory(x$0, x$1));
            });
        }
        return FormatterStep.createLazy(LicenseHeaderStep.name(), () -> {
            boolean updateYear;
            switch (this.yearMode.get()) {
                case PRESERVE: {
                    updateYear = false;
                    break;
                }
                case UPDATE_TO_TODAY: {
                    updateYear = true;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.yearMode.toString());
                }
            }
            return new Runtime(this.headerLazy.get(), this.delimiter, this.yearSeparator, updateYear);
        }, step -> x$0 -> ((Runtime)step).format(x$0));
    }

    public static String name() {
        return NAME;
    }

    public static String defaultYearDelimiter() {
        return DEFAULT_YEAR_DELIMITER;
    }

    public static SerializableFileFilter unsupportedJvmFilesFilter() {
        return UNSUPPORTED_JVM_FILES_FILTER;
    }

    public static final String FLAG_SET_LICENSE_HEADER_YEARS_FROM_GIT_HISTORY() {
        return spotlessSetLicenseHeaderYearsFromGitHistory;
    }

    private static class Runtime
    implements Serializable {
        private static final long serialVersionUID = 1475199492829130965L;
        private final Pattern delimiterPattern;
        private final String yearSepOrFull;
        @Nullable
        private final String yearToday;
        @Nullable
        private final String beforeYear;
        @Nullable
        private final String afterYear;
        private final boolean updateYearWithLatest;
        private static final Pattern YYYY = Pattern.compile("[0-9]{4}");
        private static final Pattern FIND_YEAR = Pattern.compile("Date:   .* ([0-9]{4}) ");

        private Runtime(String licenseHeader, String delimiter, String yearSeparator, boolean updateYearWithLatest) {
            if (delimiter.contains("\n")) {
                throw new IllegalArgumentException("The delimiter must not contain any newlines.");
            }
            if (!(licenseHeader = LineEnding.toUnix(licenseHeader)).isEmpty() && !licenseHeader.endsWith("\n")) {
                licenseHeader = licenseHeader + "\n";
            }
            this.delimiterPattern = Pattern.compile('^' + delimiter, 9);
            Optional<String> yearToken = Runtime.getYearToken(licenseHeader);
            if (yearToken.isPresent()) {
                this.yearToday = String.valueOf(YearMonth.now().getYear());
                int yearTokenIndex = licenseHeader.indexOf(yearToken.get());
                this.beforeYear = licenseHeader.substring(0, yearTokenIndex);
                this.afterYear = licenseHeader.substring(yearTokenIndex + yearToken.get().length());
                this.yearSepOrFull = yearSeparator;
                this.updateYearWithLatest = updateYearWithLatest;
            } else {
                this.yearToday = null;
                this.beforeYear = null;
                this.afterYear = null;
                this.yearSepOrFull = licenseHeader;
                this.updateYearWithLatest = false;
            }
        }

        private static Optional<String> getYearToken(String licenseHeader) {
            return YEAR_TOKENS.stream().filter(licenseHeader::contains).findFirst();
        }

        private String format(String raw) {
            Matcher contentMatcher = this.delimiterPattern.matcher(raw);
            if (!contentMatcher.find()) {
                throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
            }
            String content = raw.substring(contentMatcher.start());
            if (this.yearToday == null) {
                if (contentMatcher.start() == this.yearSepOrFull.length() && raw.startsWith(this.yearSepOrFull)) {
                    return raw;
                }
                return this.yearSepOrFull + content;
            }
            int beforeYearIdx = raw.indexOf(this.beforeYear);
            int afterYearIdx = raw.indexOf(this.afterYear, beforeYearIdx + this.beforeYear.length() + 1);
            if (beforeYearIdx >= 0 && afterYearIdx >= 0 && afterYearIdx + this.afterYear.length() <= contentMatcher.start()) {
                String newYear;
                String existingYear = raw.substring(beforeYearIdx + this.beforeYear.length(), afterYearIdx);
                if (existingYear.equals(newYear = this.calculateYearExact(existingYear))) {
                    boolean noPadding;
                    boolean bl = noPadding = beforeYearIdx == 0 && afterYearIdx + this.afterYear.length() == contentMatcher.start();
                    if (noPadding) {
                        return raw;
                    }
                }
                return this.beforeYear + newYear + this.afterYear + content;
            }
            String newYear = this.calculateYearBySearching(raw.substring(0, contentMatcher.start()));
            return this.beforeYear + newYear + this.afterYear + content;
        }

        private String calculateYearExact(String parsedYear) {
            if (parsedYear.equals(this.yearToday)) {
                return parsedYear;
            }
            if (YYYY.matcher(parsedYear).matches()) {
                if (this.updateYearWithLatest) {
                    return parsedYear + this.yearSepOrFull + this.yearToday;
                }
                return parsedYear;
            }
            return this.calculateYearBySearching(parsedYear);
        }

        private String calculateYearBySearching(String content) {
            Matcher yearMatcher = YYYY.matcher(content);
            if (yearMatcher.find()) {
                String firstYear = yearMatcher.group();
                String secondYear = this.updateYearWithLatest ? (firstYear.equals(this.yearToday) ? null : this.yearToday) : (yearMatcher.find(yearMatcher.end() + 1) ? yearMatcher.group() : null);
                return secondYear == null ? firstYear : firstYear + this.yearSepOrFull + secondYear;
            }
            System.err.println("Can't parse copyright year '" + content + "', defaulting to " + this.yearToday);
            return this.yearToday;
        }

        private String setLicenseHeaderYearsFromGitHistory(String raw, File file) throws IOException {
            String oldYear;
            if (this.yearToday == null) {
                return raw;
            }
            Matcher contentMatcher = this.delimiterPattern.matcher(raw);
            if (!contentMatcher.find()) {
                throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
            }
            try {
                oldYear = Runtime.parseYear("git log --follow --find-renames=40% --diff-filter=A", file);
            }
            catch (IllegalArgumentException e) {
                oldYear = Runtime.parseYear("git log --follow --find-renames=40% --reverse", file);
            }
            String newYear = Runtime.parseYear("git log --max-count=1", file);
            String yearRange = oldYear.equals(newYear) ? oldYear : oldYear + this.yearSepOrFull + newYear;
            return this.beforeYear + yearRange + this.afterYear + raw.substring(contentMatcher.start());
        }

        private static String parseYear(String cmd, File file) throws IOException {
            String fullCmd = cmd + " " + file.getAbsolutePath();
            ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(file.getParentFile());
            if (FileSignature.machineIsWin()) {
                builder.command("cmd", "/c", fullCmd);
            } else {
                builder.command("bash", "-c", fullCmd);
            }
            Process process = builder.start();
            String output = Runtime.drain(process.getInputStream());
            String error = Runtime.drain(process.getErrorStream());
            if (!error.isEmpty()) {
                throw new IllegalArgumentException("Error for command '" + fullCmd + "':\n" + error);
            }
            Matcher matcher = FIND_YEAR.matcher(output);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new IllegalArgumentException("Unable to parse date from command '" + fullCmd + "':\n" + output);
        }

        @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
        private static String drain(InputStream stream) throws IOException {
            int numRead;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((numRead = stream.read(buf)) != -1) {
                output.write(buf, 0, numRead);
            }
            return new String(output.toByteArray());
        }
    }

    public static enum YearMode {
        PRESERVE,
        UPDATE_TO_TODAY,
        SET_FROM_GIT;

    }
}

