/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmFormatterStepStateBase;
import com.diffplug.spotless.npm.NpmResourceHelper;
import com.diffplug.spotless.npm.PrettierConfig;
import com.diffplug.spotless.npm.PrettierRestService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrettierFormatterStep {
    private static final Logger logger = Logger.getLogger(PrettierFormatterStep.class.getName());
    public static final String NAME = "prettier-format";

    public static final Map<String, String> defaultDevDependencies() {
        return PrettierFormatterStep.defaultDevDependenciesWithPrettier("2.0.5");
    }

    public static final Map<String, String> defaultDevDependenciesWithPrettier(String version) {
        return Collections.singletonMap("prettier", version);
    }

    public static FormatterStep create(Map<String, String> devDependencies, Provisioner provisioner, File buildDir, @Nullable File npm, PrettierConfig prettierConfig) {
        Objects.requireNonNull(devDependencies);
        Objects.requireNonNull(provisioner);
        Objects.requireNonNull(buildDir);
        return FormatterStep.createLazy(NAME, () -> new State(NAME, devDependencies, buildDir, npm, prettierConfig), State::createFormatterFunc);
    }

    private static class PrettierFilePathPassingFormatterFunc
    implements FormatterFunc.NeedsFile {
        private final String prettierConfigOptions;
        private final PrettierRestService restService;

        public PrettierFilePathPassingFormatterFunc(String prettierConfigOptions, PrettierRestService restService) {
            this.prettierConfigOptions = Objects.requireNonNull(prettierConfigOptions);
            this.restService = Objects.requireNonNull(restService);
        }

        @Override
        public String applyWithFile(String unix, File file) throws Exception {
            String prettierConfigOptionsWithFilepath = this.assertFilepathInConfigOptions(file);
            return this.restService.format(unix, prettierConfigOptionsWithFilepath);
        }

        private String assertFilepathInConfigOptions(File file) {
            if (this.prettierConfigOptions.contains("\"filepath\"") || this.prettierConfigOptions.contains("\"parser\"")) {
                return this.prettierConfigOptions;
            }
            if (file.getName().trim().length() == 0) {
                return this.prettierConfigOptions;
            }
            int startOfConfigOption = this.prettierConfigOptions.indexOf(123);
            boolean hasAnyConfigOption = this.prettierConfigOptions.indexOf(58, startOfConfigOption + 1) != -1;
            String filePathOption = "\"filepath\":\"" + file.getName() + "\"";
            return "{" + filePathOption + (hasAnyConfigOption ? "," : "") + this.prettierConfigOptions.substring(startOfConfigOption + 1);
        }
    }

    private static class State
    extends NpmFormatterStepStateBase
    implements Serializable {
        private static final long serialVersionUID = -539537027004745812L;
        private final PrettierConfig prettierConfig;

        State(String stepName, Map<String, String> devDependencies, File buildDir, @Nullable File npm, PrettierConfig prettierConfig) throws IOException {
            super(stepName, new NpmConfig(State.replaceDevDependencies(NpmResourceHelper.readUtf8StringFromClasspath(PrettierFormatterStep.class, "/com/diffplug/spotless/npm/prettier-package.json"), new TreeMap<String, String>(devDependencies)), "prettier", NpmResourceHelper.readUtf8StringFromClasspath(PrettierFormatterStep.class, "/com/diffplug/spotless/npm/prettier-serve.js")), buildDir, npm);
            this.prettierConfig = Objects.requireNonNull(prettierConfig);
        }

        @Override
        @Nonnull
        public FormatterFunc createFormatterFunc() {
            try {
                NpmFormatterStepStateBase.ServerProcessInfo prettierRestServer = this.npmRunServer();
                PrettierRestService restService = new PrettierRestService(prettierRestServer.getBaseUrl());
                String prettierConfigOptions = restService.resolveConfig(this.prettierConfig.getPrettierConfigPath(), this.prettierConfig.getOptions());
                return FormatterFunc.Closeable.of(() -> this.endServer(restService, prettierRestServer), new PrettierFilePathPassingFormatterFunc(prettierConfigOptions, restService));
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }

        private void endServer(PrettierRestService restService, NpmFormatterStepStateBase.ServerProcessInfo restServer) throws Exception {
            try {
                restService.shutdown();
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to request shutdown of rest service via api. Trying via process.", t);
            }
            restServer.close();
        }
    }
}

