/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.scala;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public class ScalaFmtStep {
    private static final String DEFAULT_VERSION = "1.1.0";
    static final String NAME = "scalafmt";
    static final String MAVEN_COORDINATE = "com.geirsson:scalafmt-core_2.11:";

    private ScalaFmtStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return ScalaFmtStep.create(ScalaFmtStep.defaultVersion(), provisioner, null);
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable File configFile) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, configFile), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static Object invokeNoArg(Object obj, String toInvoke) throws Exception {
        Class<?> clazz = obj.getClass();
        Method method = clazz.getMethod(toInvoke, new Class[0]);
        return method.invoke(obj, new Object[0]);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final FileSignature configSignature;

        State(String version, Provisioner provisioner, @Nullable File configFile) throws IOException {
            this.jarState = JarState.from(ScalaFmtStep.MAVEN_COORDINATE + version, provisioner);
            this.configSignature = FileSignature.signAsList(configFile == null ? Collections.emptySet() : Collections.singleton(configFile));
        }

        FormatterFunc createFormat() throws Exception {
            Object config;
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatted = classLoader.loadClass("org.scalafmt.Formatted");
            Method formattedGet = formatted.getMethod("get", new Class[0]);
            Class<?> scalafmt = classLoader.loadClass("org.scalafmt.Scalafmt");
            Class<?> scalaSet = classLoader.loadClass("scala.collection.immutable.Set");
            Object defaultScalaFmtConfig = scalafmt.getMethod("format$default$2", new Class[0]).invoke(null, new Object[0]);
            Object emptyRange = scalafmt.getMethod("format$default$3", new Class[0]).invoke(null, new Object[0]);
            Method formatMethod = scalafmt.getMethod("format", String.class, defaultScalaFmtConfig.getClass(), scalaSet);
            if (this.configSignature.files().isEmpty()) {
                config = defaultScalaFmtConfig;
            } else {
                Object either;
                File file = this.configSignature.getOnlyFile();
                Class<?> optionCls = classLoader.loadClass("scala.Option");
                Class<?> configCls = classLoader.loadClass("org.scalafmt.config.Config");
                try {
                    Method fromHocon = configCls.getMethod("fromHoconString", String.class, optionCls);
                    Object fromHoconEmptyPath = configCls.getMethod("fromHoconString$default$2", new Class[0]).invoke(null, new Object[0]);
                    String configStr = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                    Object configured = fromHocon.invoke(null, configStr, fromHoconEmptyPath);
                    either = ScalaFmtStep.invokeNoArg(configured, "toEither");
                }
                catch (NoSuchMethodException e) {
                    Method fromHocon = configCls.getMethod("fromHocon", String.class, optionCls);
                    Object fromHoconEmptyPath = configCls.getMethod("fromHocon$default$2", new Class[0]).invoke(null, new Object[0]);
                    String configStr = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                    either = fromHocon.invoke(null, configStr, fromHoconEmptyPath);
                }
                config = ScalaFmtStep.invokeNoArg(ScalaFmtStep.invokeNoArg(either, "right"), "get");
            }
            return input -> {
                Object resultInsideFormatted = formatMethod.invoke(null, input, config, emptyRange);
                String result = (String)formattedGet.invoke(resultInsideFormatted, new Object[0]);
                return result;
            };
        }
    }
}

