/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SpotlessCache;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class JarState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String mavenCoordinate;
    private final FileSignature fileSignature;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient Set<File> jars;

    public JarState(String mavenCoordinate, FileSignature fileSignature, Set<File> jars) {
        this.mavenCoordinate = mavenCoordinate;
        this.fileSignature = fileSignature;
        this.jars = jars;
    }

    public static JarState from(String mavenCoordinate, Provisioner provisioner) throws IOException {
        Objects.requireNonNull(mavenCoordinate, "mavenCoordinate");
        Objects.requireNonNull(provisioner, "provisioner");
        Set<File> jars = provisioner.provisionWithDependencies(mavenCoordinate);
        if (jars.isEmpty()) {
            throw new NoSuchElementException("Resolved to an empty result: " + mavenCoordinate);
        }
        FileSignature fileSignature = FileSignature.signAsSet(jars);
        return new JarState(mavenCoordinate, fileSignature, jars);
    }

    URL[] jarUrls() {
        return (URL[])this.jars.stream().map(File::toURI).map(ThrowingEx.wrap(URI::toURL)).toArray(URL[]::new);
    }

    public ClassLoader getClassLoader() {
        return SpotlessCache.instance().classloader(this);
    }
}

