/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseHeaderStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "licenseHeader";
    private final String licenseHeader;
    private final Pattern delimiterPattern;

    public static FormatterStep createFromHeader(String licenseHeader, String delimiter) {
        Objects.requireNonNull(licenseHeader, NAME);
        Objects.requireNonNull(delimiter, "delimiter");
        return FormatterStep.create(NAME, new LicenseHeaderStep(licenseHeader, delimiter), step -> step::format);
    }

    public static FormatterStep createFromFile(File licenseHeaderFile, Charset encoding, String delimiter) {
        Objects.requireNonNull(licenseHeaderFile, "licenseHeaderFile");
        Objects.requireNonNull(encoding, "encoding");
        Objects.requireNonNull(delimiter, "delimiter");
        return FormatterStep.createLazy(NAME, () -> new LicenseHeaderStep(licenseHeaderFile, encoding, delimiter), step -> step::format);
    }

    public static String name() {
        return NAME;
    }

    private LicenseHeaderStep(String licenseHeader, String delimiter) {
        if (delimiter.contains("\n")) {
            throw new IllegalArgumentException("The delimiter must not contain any newlines.");
        }
        if (!(licenseHeader = LineEnding.toUnix(licenseHeader)).endsWith("\n")) {
            licenseHeader = licenseHeader + "\n";
        }
        this.licenseHeader = licenseHeader;
        this.delimiterPattern = Pattern.compile('^' + delimiter, 9);
    }

    private LicenseHeaderStep(File licenseFile, Charset encoding, String delimiter) throws IOException {
        this(new String(Files.readAllBytes(licenseFile.toPath()), encoding), delimiter);
    }

    public String format(String raw) {
        Matcher matcher = this.delimiterPattern.matcher(raw);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
        }
        if (matcher.start() == this.licenseHeader.length() && raw.startsWith(this.licenseHeader)) {
            return raw;
        }
        return this.licenseHeader + raw.substring(matcher.start());
    }
}

