/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.integration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

class WriteSpaceAwareDiffFormatter {
    private static final int CONTEXT_LINES = 3;
    private static final String MIDDLE_DOT = "\u00b7";
    private static final String CR = "\u240d";
    private static final String LF = "\u240a";
    private static final String TAB = "\u21e5";
    private static final byte[] MIDDLE_DOT_UTF8 = "\u00b7".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CR_UTF8 = "\u240d".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LF_UTF8 = "\u240a".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TAB_UTF8 = "\u21e5".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SPACE_SIMPLE = new byte[]{32};
    private static final byte[] CR_SIMPLE = new byte[]{92, 114};
    private static final byte[] LF_SIMPLE = new byte[]{92, 110};
    private static final byte[] TAB_SIMPLE = new byte[]{92, 116};
    private final ByteArrayOutputStream out;
    private final byte[] middleDot;
    private final byte[] cr;
    private final byte[] lf;
    private final byte[] tab;

    public WriteSpaceAwareDiffFormatter(ByteArrayOutputStream out, Charset charset) {
        this.out = out;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        this.middleDot = WriteSpaceAwareDiffFormatter.replacementFor(charsetEncoder, MIDDLE_DOT, MIDDLE_DOT_UTF8, SPACE_SIMPLE);
        this.cr = WriteSpaceAwareDiffFormatter.replacementFor(charsetEncoder, CR, CR_UTF8, CR_SIMPLE);
        this.lf = WriteSpaceAwareDiffFormatter.replacementFor(charsetEncoder, LF, LF_UTF8, LF_SIMPLE);
        this.tab = WriteSpaceAwareDiffFormatter.replacementFor(charsetEncoder, TAB, TAB_UTF8, TAB_SIMPLE);
    }

    private static byte[] replacementFor(CharsetEncoder charsetEncoder, String value, byte[] fancy, byte[] simple) {
        return charsetEncoder.canEncode(value) ? fancy : simple;
    }

    public void format(EditList edits, RawText a, RawText b) throws IOException {
        IntList linesA = RawParseUtils.lineMap((byte[])a.getRawContent(), (int)0, (int)a.getRawContent().length);
        IntList linesB = RawParseUtils.lineMap((byte[])b.getRawContent(), (int)0, (int)b.getRawContent().length);
        boolean firstLine = true;
        for (int i = 0; i < edits.size(); ++i) {
            boolean showWhitespace;
            Edit edit = (Edit)edits.get(i);
            int lineA = Math.max(0, edit.getBeginA() - 3);
            int lineB = Math.max(0, edit.getBeginB() - 3);
            int endIdx = this.findCombinedEnd(edits, i);
            Edit endEdit = (Edit)edits.get(endIdx);
            int endA = Math.min(a.size(), endEdit.getEndA() + 3);
            int endB = Math.min(b.size(), endEdit.getEndB() + 3);
            if (firstLine) {
                firstLine = false;
            } else {
                this.out.write(10);
            }
            this.header(lineA, endA, lineB, endB);
            boolean bl = showWhitespace = edit.getType() == Edit.Type.REPLACE;
            while (lineA < endA || lineB < endB) {
                if (lineA < edit.getBeginA()) {
                    this.line(' ', a, lineA, linesA, false);
                    ++lineA;
                    ++lineB;
                } else if (lineA < edit.getEndA()) {
                    this.line('-', a, lineA, linesA, showWhitespace);
                    ++lineA;
                } else if (lineB < edit.getEndB()) {
                    this.line('+', b, lineB, linesB, showWhitespace);
                    ++lineB;
                } else {
                    this.line(' ', a, lineA, linesA, false);
                    ++lineA;
                    ++lineB;
                }
                if (lineA != edit.getEndA() || lineB != edit.getEndB() || i >= endIdx) continue;
                showWhitespace = (edit = (Edit)edits.get(++i)).getType() == Edit.Type.REPLACE;
            }
        }
    }

    private int findCombinedEnd(EditList edits, int i) {
        while (i < edits.size() - 1) {
            Edit current = (Edit)edits.get(i);
            Edit next = (Edit)edits.get(i + 1);
            if (current.getEndA() - next.getBeginA() > 6 && current.getEndB() - next.getBeginB() > 6) break;
            ++i;
        }
        return i;
    }

    private void header(int lineA, int endA, int lineB, int endB) {
        this.out.write(64);
        this.out.write(64);
        this.range('-', lineA + 1, endA - lineA);
        this.range('+', lineB + 1, endB - lineB);
        this.out.write(32);
        this.out.write(64);
        this.out.write(64);
    }

    private void range(char prefix, int begin, int length) {
        this.out.write(32);
        this.out.write(prefix);
        if (length == 0) {
            this.writeInt(begin - 1);
            this.out.write(44);
            this.out.write(48);
        } else {
            this.writeInt(begin);
            if (length > 1) {
                this.out.write(44);
                this.writeInt(length);
            }
        }
    }

    private void writeInt(int num) {
        String str = Integer.toString(num);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.out.write(str.charAt(i));
        }
    }

    private void line(char prefix, RawText a, int lineA, IntList lines, boolean showWhitespace) throws IOException {
        this.out.write(10);
        this.out.write(prefix);
        if (!showWhitespace) {
            a.writeLine((OutputStream)this.out, lineA);
            return;
        }
        byte[] bytes = a.getRawContent();
        int end = lines.get(lineA + 2);
        for (int i = lines.get(lineA + 1); i < end; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                this.out.write(this.middleDot);
                continue;
            }
            if (b == 9) {
                this.out.write(this.tab);
                continue;
            }
            if (b == 13) {
                this.out.write(this.cr);
                continue;
            }
            if (b == 10) {
                this.out.write(this.lf);
                continue;
            }
            this.out.write(b);
        }
    }
}

