/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.regions.AttributeEqualsRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.AttributeNameRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.AttributeValueRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.EmptyTagCloseRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.EndTagOpenRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.TagCloseRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.TagNameRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.TagOpenRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.WhiteSpaceOnlyRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLCDataTextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLContentRegion;

public class XMLParserRegionFactory {
    public ITextRegion createToken(ITextRegionContainer parent, String context, int start, int textLength, int length) {
        return this.createToken(parent, context, start, textLength, length, null, null);
    }

    public ITextRegion createToken(ITextRegionContainer parent, String context, int start, int textLength, int length, String lang, String surroundingTag) {
        ITextRegion newRegion = this.createToken(context, start, textLength, length);
        return newRegion;
    }

    public ITextRegion createToken(String context, int start, int textLength, int length) {
        return this.createToken(context, start, textLength, length, null, null);
    }

    public ITextRegion createToken(String context, int start, int textLength, int length, String lang, String surroundingTag) {
        ITextRegion newRegion = null;
        if (context == "XML_CDATA_TEXT") {
            newRegion = new XMLCDataTextRegion(start, textLength, length);
        } else if (context == "XML_CONTENT") {
            newRegion = new XMLContentRegion(start, length);
        } else if (context == "XML_TAG_NAME") {
            newRegion = new TagNameRegion(start, textLength, length);
        } else if (context == "XML_TAG_ATTRIBUTE_NAME") {
            newRegion = new AttributeNameRegion(start, textLength, length);
        } else if (context == "XML_TAG_ATTRIBUTE_EQUALS") {
            newRegion = new AttributeEqualsRegion(start, textLength, length);
        } else if (context == "XML_TAG_ATTRIBUTE_VALUE") {
            newRegion = new AttributeValueRegion(start, textLength, length);
        } else if (context == "XML_TAG_OPEN") {
            newRegion = new TagOpenRegion(start, textLength, length);
        } else if (context == "XML_END_TAG_OPEN") {
            newRegion = new EndTagOpenRegion(start, textLength, length);
        } else if (context == "XML_TAG_CLOSE") {
            newRegion = new TagCloseRegion(start);
        } else if (context == "XML_EMPTY_TAG_CLOSE") {
            newRegion = new EmptyTagCloseRegion(start, textLength, length);
        } else if (context == "WHITE_SPACE") {
            newRegion = new WhiteSpaceOnlyRegion(start, length);
        } else if (context == "BLOCK_TEXT") {
            newRegion = new ForeignRegion(context, start, textLength, length);
            ((ForeignRegion)newRegion).setSurroundingTag(surroundingTag);
        } else {
            newRegion = new ContextRegion(context, start, textLength, length);
        }
        return newRegion;
    }
}

