/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.AbstractRuntimeInstallPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;

public class StandardRuntimeInstallPage
extends AbstractRuntimeInstallPage {
    private JSRuntimeWorkingCopy fRuntimeInstall;
    private Text fRuntimeName;
    private Text fRuntimeArgs;
    private Text fRuntimeLocation;
    private IStatus[] fFieldStatus = new IStatus[1];

    public StandardRuntimeInstallPage() {
        super(PreferencesMessages.StandardRuntimeInstallPage_PageTitle);
        int i = 0;
        while (i < this.fFieldStatus.length) {
            this.fFieldStatus[i] = Status.OK_STATUS;
            ++i;
        }
    }

    public void createControl(Composite p) {
        Composite composite = new Composite(p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel((Composite)composite, (String)PreferencesMessages.StandardRuntimeInstallPage_RuntimeLocationField_Label, (int)1);
        this.fRuntimeLocation = SWTFactory.createSingleText((Composite)composite, (int)1);
        Button folders = SWTFactory.createPushButton((Composite)composite, (String)PreferencesMessages.StandardRuntimeInstallPage_RuntimeLocationFileButton_Label, null);
        GridData data = (GridData)folders.getLayoutData();
        data.horizontalAlignment = 3;
        SWTFactory.createLabel((Composite)composite, (String)PreferencesMessages.StandardRuntimeInstallPage_RuntimeLocationNameField_Label, (int)1);
        this.fRuntimeName = SWTFactory.createSingleText((Composite)composite, (int)2);
        SWTFactory.createLabel((Composite)composite, (String)PreferencesMessages.StandardRuntimeInstallPage_RuntimeArgumentsField_Label, (int)1);
        this.fRuntimeArgs = SWTFactory.createSingleText((Composite)composite, (int)1);
        Button variables = SWTFactory.createPushButton((Composite)composite, (String)PreferencesMessages.StandardRuntimeInstallPage_RuntimeLocationVariablesButton_Label, null);
        data = (GridData)variables.getLayoutData();
        data.horizontalAlignment = 3;
        this.fRuntimeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardRuntimeInstallPage.this.validateRuntimeName();
            }
        });
        this.fRuntimeLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardRuntimeInstallPage.this.validateRuntimeLocation();
            }
        });
        folders.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(StandardRuntimeInstallPage.this.getShell());
                File file = new File(StandardRuntimeInstallPage.this.fRuntimeLocation.getText());
                String text = StandardRuntimeInstallPage.this.fRuntimeLocation.getText();
                if (file.isFile()) {
                    text = file.getAbsolutePath();
                }
                dialog.setFilterPath(text);
                String newPath = dialog.open();
                if (newPath != null) {
                    StandardRuntimeInstallPage.this.fRuntimeLocation.setText(newPath);
                }
            }
        });
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String expression;
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(StandardRuntimeInstallPage.this.getShell());
                if (dialog.open() == 0 && (expression = dialog.getVariableExpression()) != null) {
                    StandardRuntimeInstallPage.this.fRuntimeArgs.insert(expression);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.initializeFields();
    }

    private void validateRuntimeLocation() {
        String name;
        String locationName = this.fRuntimeLocation.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(4, PreferencesMessages.StandardRuntimeInstallPage_RuntimeEmptyLocation_Error);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, PreferencesMessages.StandardRuntimeInstallPage_RuntimeUnexistingLocation_Error);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        temp[0] = StandardRuntimeInstallPage.this.fRuntimeInstall.getRuntimeType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (file != null) {
            this.fRuntimeInstall.setInstallLocation(file);
        }
        if (s.isOK() && file != null && ((name = this.fRuntimeName.getText()) == null || name.trim().length() == 0)) {
            if (file.isFile()) {
                String fileName = file.getName();
                this.fRuntimeName.setText(fileName);
            } else {
                try {
                    String genName = null;
                    Path path = new Path(file.getCanonicalPath());
                    int segs = path.segmentCount();
                    if (segs == 1) {
                        genName = path.segment(0);
                    } else if (segs >= 2) {
                        genName = path.lastSegment();
                    }
                    if (genName != null) {
                        this.fRuntimeName.setText(genName);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.setRuntimeInstallLocationStatus(s);
        this.updatePageStatus();
    }

    protected File getInstallLocation() {
        return new File(this.fRuntimeLocation.getText());
    }

    private void validateRuntimeName() {
        this.nameChanged(this.fRuntimeName.getText());
    }

    @Override
    public boolean finish() {
        this.setFieldValuesToRuntime(this.fRuntimeInstall);
        return true;
    }

    @Override
    public JSRuntimeWorkingCopy getSelection() {
        return this.fRuntimeInstall;
    }

    @Override
    public void setSelection(JSRuntimeWorkingCopy runtime) {
        super.setSelection(runtime);
        this.fRuntimeInstall = runtime;
        this.setTitle(PreferencesMessages.StandardRuntimeInstallPage_RuntimeDefinition_Title);
        this.setDescription(PreferencesMessages.StandardRuntimeInstallPage_RuntimeAttributes_Message);
    }

    protected void setFieldValuesToRuntime(JSRuntimeWorkingCopy runtime) {
        File dir = new File(this.fRuntimeLocation.getText());
        File file = dir.getAbsoluteFile();
        runtime.setInstallLocation(file);
        runtime.setName(this.fRuntimeName.getText());
        String argString = this.fRuntimeArgs.getText().trim();
        if (argString != null && argString.length() > 0) {
            runtime.setJSRuntimeArguments(argString);
        } else {
            runtime.setJSRuntimeArguments(null);
        }
    }

    protected static String createUniqueId(IJSRuntimeType runtimeType) {
        String id = null;
        while (JSRuntimeManager.getJSRuntimeInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    private void initializeFields() {
        String runtimeArgs;
        this.fRuntimeName.setText(this.fRuntimeInstall.getName());
        File installLocation = this.fRuntimeInstall.getInstallLocation();
        if (installLocation != null) {
            this.fRuntimeLocation.setText(installLocation.getAbsolutePath());
        }
        if ((runtimeArgs = this.fRuntimeInstall.getJSRuntimeArgumentsAsString()) != null) {
            this.fRuntimeArgs.setText(runtimeArgs);
        }
        this.validateRuntimeName();
        this.validateRuntimeLocation();
    }

    private void setRuntimeInstallLocationStatus(IStatus status) {
        this.fFieldStatus[0] = status;
    }

    public String getErrorMessage() {
        String message = super.getErrorMessage();
        return message;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        return complete;
    }

    @Override
    protected IStatus[] getRuntimeStatus() {
        return this.fFieldStatus;
    }
}

