/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public abstract class CSSRegionContainer
extends CSSNodeImpl {
    private ITextRegion fFirstRegion = null;
    private ITextRegion fLastRegion = null;
    private IStructuredDocumentRegion fParentRegion = null;

    CSSRegionContainer() {
    }

    CSSRegionContainer(CSSRegionContainer that) {
        super(that);
    }

    public String getCssText() {
        if (this.fFirstRegion == null || this.fLastRegion == null) {
            return this.generateSource();
        }
        ITextRegionList regions = this.fParentRegion.getRegions();
        StringBuffer source = new StringBuffer();
        boolean bIn = false;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion current = regions.get(i);
            if (bIn) {
                source.append(this.fParentRegion.getFullText(current));
                if (current == this.fLastRegion) {
                    break;
                }
            } else if (current == this.fFirstRegion) {
                bIn = true;
                source.append(this.fParentRegion.getFullText(current));
                if (current == this.fLastRegion) break;
            }
            ++i;
        }
        return source.toString();
    }

    @Override
    public int getEndOffset() {
        int result = -1;
        ITextRegion region = this.getLastRegion();
        if (region != null && this.fParentRegion != null) {
            result = this.fParentRegion.getEndOffset(region);
        }
        return result;
    }

    IStructuredDocumentRegion getDocumentRegion() {
        return this.fParentRegion;
    }

    public ITextRegion getFirstRegion() {
        return this.fFirstRegion;
    }

    ITextRegion getLastRegion() {
        return this.fLastRegion;
    }

    ITextRegion getRegion(int index) {
        if (this.getFirstRegion() == null) {
            return null;
        }
        ITextRegionList regions = this.fParentRegion.getRegions();
        int i = 0;
        while (i < regions.size()) {
            if (regions.get(i) == this.getFirstRegion()) {
                ITextRegion target;
                if (i + index < regions.size() && (target = regions.get(i + index)).getStart() <= this.getLastRegion().getStart()) {
                    return target;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    int getRegionCount() {
        this.validateRange();
        if (this.getFirstRegion() == null) {
            return 0;
        }
        if (this.getFirstRegion() == this.getLastRegion()) {
            return 1;
        }
        ITextRegionList regions = this.fParentRegion.getRegions();
        int j = 0;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion current = regions.get(i);
            if (j != 0 || current == this.getFirstRegion()) {
                ++j;
            }
            if (current == this.getLastRegion()) break;
            ++i;
        }
        return j;
    }

    @Override
    public int getStartOffset() {
        int result = -1;
        ITextRegion region = this.getFirstRegion();
        if (region != null && this.fParentRegion != null) {
            result = this.fParentRegion.getStartOffset(region);
        }
        return result;
    }

    ITextRegion setFirstRegion(ITextRegion region) {
        this.fFirstRegion = region;
        return region;
    }

    ITextRegion setLastRegion(ITextRegion lastRegion) {
        this.fLastRegion = lastRegion;
        return lastRegion;
    }

    void setRangeRegion(IStructuredDocumentRegion parentRegion, ITextRegion firstRegion, ITextRegion lastRegion) {
        this.fParentRegion = parentRegion;
        this.fFirstRegion = firstRegion;
        this.fLastRegion = lastRegion;
        if (firstRegion == null && lastRegion == null) {
            this.setFirstRegion(null);
            this.setLastRegion(null);
        } else {
            this.validateRange();
        }
    }

    private boolean validateRange() {
        boolean bModified = false;
        if (this.fFirstRegion != null || this.fLastRegion != null) {
            if (this.fFirstRegion == null) {
                this.fFirstRegion = this.fLastRegion;
                bModified = true;
            } else if (this.fLastRegion == null) {
                this.fLastRegion = this.fFirstRegion;
                bModified = true;
            } else if (this.fFirstRegion.getStart() > this.fLastRegion.getStart()) {
                ITextRegion reg = this.fFirstRegion;
                this.fFirstRegion = this.fLastRegion;
                this.fLastRegion = reg;
                bModified = true;
            }
        }
        return bModified;
    }
}

