/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;

public class XMLHeadParserRegion
implements ITextRegion {
    private int fLength;
    private int fStart;
    private String fText;
    private int fTextLength;
    private String fType = "UNDEFINED";

    public XMLHeadParserRegion() {
    }

    public XMLHeadParserRegion(String context, int start, int textLength, int length, String text) {
        this();
        this.fType = context;
        this.fStart = start;
        this.fTextLength = textLength;
        this.fLength = length;
        this.fText = text;
    }

    @Override
    public void adjustLength(int i) {
        this.fLength += i;
    }

    @Override
    public void adjustStart(int i) {
        this.fStart += i;
    }

    @Override
    public void adjustTextLength(int i) {
        ++this.fTextLength;
    }

    @Override
    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
        this.fTextLength = region.getTextLength();
    }

    @Override
    public int getEnd() {
        return this.fStart + this.fLength;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStart() {
        return this.fStart;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public int getTextEnd() {
        return this.fStart + this.fTextLength;
    }

    @Override
    public int getTextLength() {
        return this.fTextLength;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    @Override
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        return null;
    }
}

