/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.formatter;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.formatter.DefaultXMLPartitionFormatter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class XMLFormatterFormatProcessor
implements IStructuredFormatProcessor {
    private DefaultXMLPartitionFormatter fFormatter = null;
    private IProgressMonitor fProgressMonitor = null;

    @Override
    public void formatDocument(IDocument document, int start, int length) throws IOException, CoreException {
        IStructuredModel model;
        if (document instanceof IStructuredDocument && (model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document)) != null) {
            try {
                this.formatModel(model, start, length);
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }

    @Override
    public void formatFile(IFile file) throws IOException, CoreException {
        if (file == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(file);
            this.formatModel(structuredModel);
            if (structuredModel != null && !structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    @Override
    public void formatModel(IStructuredModel structuredModel) {
        if (structuredModel == null) {
            return;
        }
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.formatModel(structuredModel, start, length);
    }

    @Override
    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.beginTask("", 2);
        }
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        DocumentRewriteSession activeRewriteSession = ((IDocumentExtension4)structuredDocument).getActiveRewriteSession();
        boolean startedRewriteSession = false;
        if (activeRewriteSession == null) {
            activeRewriteSession = ((IDocumentExtension4)structuredDocument).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            startedRewriteSession = true;
        }
        this.getFormatter().setProgressMonitor((IProgressMonitor)new NullProgressMonitor(){

            public boolean isCanceled() {
                return XMLFormatterFormatProcessor.this.fProgressMonitor != null && XMLFormatterFormatProcessor.this.fProgressMonitor.isCanceled();
            }
        });
        TextEdit edit = this.getFormatter().format(structuredModel, start, length);
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(1);
        }
        try {
            try {
                structuredModel.aboutToChangeModel();
                edit.apply((IDocument)structuredDocument);
                if (this.fProgressMonitor != null) {
                    this.fProgressMonitor.worked(1);
                }
            }
            catch (Exception e) {
                Logger.log(202, e.getMessage(), e);
                if (startedRewriteSession && activeRewriteSession != null) {
                    ((IDocumentExtension4)structuredDocument).stopRewriteSession(activeRewriteSession);
                }
                structuredModel.changedModel();
                if (this.fProgressMonitor != null) {
                    this.fProgressMonitor.done();
                }
            }
        }
        finally {
            if (startedRewriteSession && activeRewriteSession != null) {
                ((IDocumentExtension4)structuredDocument).stopRewriteSession(activeRewriteSession);
            }
            structuredModel.changedModel();
            if (this.fProgressMonitor != null) {
                this.fProgressMonitor.done();
            }
        }
    }

    @Override
    public void formatNode(Node node) {
        if (node instanceof IDOMNode) {
            IDOMNode domNode = (IDOMNode)node;
            this.formatModel(domNode.getModel(), domNode.getStartOffset(), domNode.getLength());
        }
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private DefaultXMLPartitionFormatter getFormatter() {
        if (this.fFormatter == null) {
            this.fFormatter = new DefaultXMLPartitionFormatter();
        }
        return this.fFormatter;
    }
}

