/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.internal.format.AbstractJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.CompoundRegion;
import org.eclipse.wst.json.core.internal.format.FormatRegion;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONSourceFormatterFactory;
import org.eclipse.wst.json.core.internal.format.JSONStructureFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class JSONPairFormatter
extends JSONStructureFormatter {
    private static AbstractJSONSourceFormatter instance;

    JSONPairFormatter() {
    }

    @Override
    protected void formatChildren(IJSONNode node, StringBuilder source) {
        if (node instanceof IJSONPair) {
            IJSONPair pair = (IJSONPair)node;
            IJSONValue value = pair.getValue();
            if (value instanceof IJSONObject || value instanceof IJSONArray) {
                this.formatObject(node, source, value);
            } else {
                this.formatValue(node, source, value);
            }
        }
    }

    @Override
    protected void formatChildren(IJSONNode node, IRegion region, StringBuilder source) {
        IJSONNode child = node.getFirstChild();
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        while (child != null) {
            int curEnd = child.getEndOffset();
            StringBuilder childSource = null;
            boolean toFinish = false;
            if (start < curEnd) {
                int curStart = child.getStartOffset();
                if (curStart < end) {
                    IJSONSourceFormatter formatter = (IJSONSourceFormatter)((Object)child.getAdapterFor(IJSONSourceFormatter.class));
                    if (formatter == null) {
                        formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(child);
                    }
                    childSource = JSONPairFormatter.includes(region, curStart, curEnd) ? ((AbstractJSONSourceFormatter)formatter).formatProc(child) : ((AbstractJSONSourceFormatter)formatter).formatProc(child, JSONPairFormatter.overlappedRegion(region, curStart, curEnd));
                } else {
                    toFinish = true;
                }
            }
            if (childSource != null) {
                source.append((CharSequence)childSource);
            }
            if (toFinish) break;
            child = child.getNextSibling();
        }
    }

    @Override
    protected void formatPre(IJSONNode node, StringBuilder source) {
        this.formatPre(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    @Override
    protected void formatPre(IJSONNode node, IRegion region, StringBuilder source) {
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        int length = regions.length >= 2 ? 2 : regions.length;
        int i = 0;
        while (i < length) {
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            if (regions[i].getType() == "JSON_COLON") {
                source.append(' ');
            }
            ++i;
        }
    }

    @Override
    protected void formatPost(IJSONNode node, IRegion region, StringBuilder source) {
        if (node.getNextSibling() != null) {
            int start = node.getEndOffset();
            int end = node.getNextSibling().getStartOffset();
            IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            String delim = this.getLineDelimiter(node);
            source.append(delim);
            if (node.getNextSibling() != null) {
                source.append(this.getIndent(node));
            } else {
                source.append(this.getIndent(node.getParentNode()));
            }
        }
    }

    @Override
    protected void formatPost(IJSONNode node, StringBuilder source) {
        this.formatPost(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    public static synchronized AbstractJSONSourceFormatter getInstance() {
        if (instance == null) {
            instance = new JSONPairFormatter();
        }
        return instance;
    }
}

