/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Node;

public class JSONFormatUtil {
    private static JSONFormatUtil fInstance;

    public List collectJSONNodes(IStructuredModel model, int start, int length) {
        IJSONNode ca;
        ArrayList<IJSONNode> nodes = new ArrayList<IJSONNode>();
        IndexedRegion startNode = model.getIndexedRegion(start);
        IndexedRegion endNode = model.getIndexedRegion(start + length - 1);
        if (startNode == null || endNode == null) {
            return nodes;
        }
        if (model instanceof IJSONModel && startNode instanceof IJSONNode && endNode instanceof IJSONNode && (ca = this.getCommonAncestor((IJSONNode)startNode, (IJSONNode)endNode)) != null) {
            IJSONNode node = ca.getFirstChild();
            while (node != null && start + length < node.getStartOffset()) {
                if (start < node.getEndOffset()) {
                    nodes.add(node);
                }
                node = node.getNextSibling();
            }
        }
        return nodes;
    }

    private Node getCommonAncestor(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        Node na = node2;
        while (na != null) {
            Node ta = node1;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    private IJSONNode getCommonAncestor(IJSONNode nodeA, IJSONNode nodeB) {
        if (nodeA == null || nodeB == null) {
            return null;
        }
        IJSONNode na = nodeA;
        while (na != null) {
            IJSONNode ta = nodeB;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    public void replaceSource(IStructuredModel model, int offset, int length, String source) {
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (offset >= 0 && length >= 0 && offset + length <= structuredDocument.getLength()) {
            if (structuredDocument.containsReadOnly(offset, length)) {
                return;
            }
            if (source == null) {
                source = new String();
            }
            structuredDocument.replaceText(structuredDocument, offset, length, source);
        }
    }

    public static synchronized JSONFormatUtil getInstance() {
        if (fInstance == null) {
            fInstance = new JSONFormatUtil();
        }
        return fInstance;
    }

    private JSONFormatUtil() {
    }
}

