/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticToken;

public class SemanticHighlightings {
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ANNOTATION_ELEMENT_REFERENCE = "annotationElementReference";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String DEPRECATED_MEMBER = "deprecatedMember";
    public static final String TYPE_VARIABLE = "typeParameter";
    public static final String OBJECT_INITIALIZER = "objectInitializer";
    public static final String METHOD = "method";
    public static final String AUTOBOXING = "autoboxing";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String INTERFACE = "interface";
    public static final String ANNOTATION = "annotation";
    public static final String TYPE_ARGUMENT = "typeArgument";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public RGB getDefaultDefaultTextColor() {
        return new RGB(13, 100, 0);
    }

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new ObjectInitializerHighlighting(), new DeprecatedMemberHighlighting(), new MethodDeclarationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new MethodHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            SemanticHighlightings.setDefaultAndFireEvent(store, SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++i;
        }
        SemanticHighlightings.convertMethodHighlightingPreferences(store);
        SemanticHighlightings.convertAnnotationHighlightingPreferences(store);
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private static void convertMethodHighlightingPreferences(IPreferenceStore store) {
        String colorkey = "semanticHighlighting.method.color";
        String boldkey = "semanticHighlighting.method.bold";
        String italickey = "semanticHighlighting.method.italic";
        String enabledkey = "semanticHighlighting.method.enabled";
        String oldColorkey = "java_method_name";
        String oldBoldkey = "java_method_name_bold";
        String oldItalickey = "java_method_name_italic";
        if (SemanticHighlightings.conditionalReset(store, oldColorkey, colorkey) || SemanticHighlightings.conditionalReset(store, oldBoldkey, boldkey) || SemanticHighlightings.conditionalReset(store, oldItalickey, italickey)) {
            store.setValue(enabledkey, true);
        }
    }

    private static void convertAnnotationHighlightingPreferences(IPreferenceStore store) {
        String colorkey = "semanticHighlighting.annotation.color";
        String boldkey = "semanticHighlighting.annotation.bold";
        String italickey = "semanticHighlighting.annotation.italic";
        String strikethroughKey = "semanticHighlighting.annotation.strikethrough";
        String underlineKey = "semanticHighlighting.annotation.underline";
        String enabledkey = "semanticHighlighting.annotation.enabled";
        String oldColorkey = "java_annotation";
        String oldBoldkey = "java_annotation_bold";
        String oldItalickey = "java_annotation_italic";
        String oldStrikethroughKey = "java_annotation_strikethrough";
        String oldUnderlineKey = "java_annotation_underline";
        if (SemanticHighlightings.conditionalReset(store, oldColorkey, colorkey) || SemanticHighlightings.conditionalReset(store, oldBoldkey, boldkey) || SemanticHighlightings.conditionalReset(store, oldItalickey, italickey) || SemanticHighlightings.conditionalReset(store, oldStrikethroughKey, strikethroughKey) || SemanticHighlightings.conditionalReset(store, oldUnderlineKey, underlineKey)) {
            store.setValue(enabledkey, true);
        }
    }

    private static boolean conditionalReset(IPreferenceStore store, String oldKey, String newKey) {
        if (!store.isDefault(oldKey)) {
            if (store.isDefault(newKey)) {
                store.setValue(newKey, store.getString(oldKey));
            }
            store.setToDefault(oldKey);
            return true;
        }
        return false;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore store, String key, RGB newValue) {
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private SemanticHighlightings() {
    }

    private static final class DeprecatedMemberHighlighting
    extends SemanticHighlighting {
        private DeprecatedMemberHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.DEPRECATED_MEMBER;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isStrikethroughByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_deprecatedMember;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = this.getMethodBinding(token);
            return binding != null ? binding.isDeprecated() : false;
        }

        private IBinding getMethodBinding(SemanticToken token) {
            IBinding binding = null;
            ASTNode node = token.getNode();
            ASTNode parent = node.getParent();
            while (this.isTypePath(node, parent)) {
                node = parent;
                parent = parent.getParent();
            }
            binding = parent != null && node.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)parent).resolveConstructorBinding() : token.getBinding();
            return binding;
        }

        private boolean isTypePath(ASTNode child, ASTNode parent) {
            if (parent instanceof Type) {
                StructuralPropertyDescriptor location = child.getLocationInParent();
                return location == SimpleType.NAME_PROPERTY;
            }
            if (parent instanceof QualifiedName) {
                StructuralPropertyDescriptor location = child.getLocationInParent();
                return location == QualifiedName.NAME_PROPERTY;
            }
            return false;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariableDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ASTNode parent;
            SimpleName node = token.getNode();
            StructuralPropertyDescriptor location = node.getLocationInParent();
            if ((location == VariableDeclarationFragment.NAME_PROPERTY || location == SingleVariableDeclaration.NAME_PROPERTY) && (parent = node.getParent()) instanceof VariableDeclaration) {
                return (parent = parent.getParent()) == null || !(parent instanceof FieldDeclaration);
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl instanceof VariableDeclaration;
            }
            return false;
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_methodDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            StructuralPropertyDescriptor location = token.getNode().getLocationInParent();
            return location == FunctionDeclaration.NAME_PROPERTY;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_method;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = this.getMethodBinding(token);
            return binding != null && binding.getKind() == 4;
        }

        private IBinding getMethodBinding(SemanticToken token) {
            IBinding binding = null;
            ASTNode node = token.getNode();
            ASTNode parent = node.getParent();
            while (this.isTypePath(node, parent)) {
                node = parent;
                parent = parent.getParent();
            }
            binding = parent != null && node.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY ? ((ClassInstanceCreation)parent).resolveConstructorBinding() : token.getBinding();
            return binding;
        }

        private boolean isTypePath(ASTNode child, ASTNode parent) {
            if (parent instanceof Type) {
                StructuralPropertyDescriptor location = child.getLocationInParent();
                return location == SimpleType.NAME_PROPERTY;
            }
            if (parent instanceof QualifiedName) {
                StructuralPropertyDescriptor location = child.getLocationInParent();
                return location == QualifiedName.NAME_PROPERTY;
            }
            return false;
        }
    }

    private static final class ObjectInitializerHighlighting
    extends SemanticHighlighting {
        private ObjectInitializerHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.OBJECT_INITIALIZER;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_objectInitializer;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            StructuralPropertyDescriptor location = node.getLocationInParent();
            if (location == ObjectLiteralField.FIELD_NAME_PROPERTY) {
                ASTNode parent = node.getParent();
                return parent != null && parent instanceof ObjectLiteral;
            }
            return false;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_parameterVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl != null && decl.getLocationInParent() == FunctionDeclaration.PARAMETERS_PROPERTY;
            }
            return false;
        }
    }
}

