/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleDeclarationAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.HTMLDocumentAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.LinkElementAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAttrAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.StyleElementAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StyleAdapterFactory
implements INodeAdapterFactory {
    private static StyleAdapterFactory instance = null;

    private StyleAdapterFactory() {
    }

    @Override
    public INodeAdapter adapt(INodeNotifier notifier) {
        if (notifier == null) {
            return null;
        }
        Node node = (Node)((Object)notifier);
        short nodeType = node.getNodeType();
        if (nodeType == 9) {
            INodeAdapter adapter = notifier.getExistingAdapter(IStyleSheetListAdapter.class);
            if (adapter != null) {
                return adapter;
            }
            HTMLDocumentAdapter newAdapter = new HTMLDocumentAdapter();
            newAdapter.setDocument((Document)node);
            notifier.addAdapter(newAdapter);
            return newAdapter;
        }
        if (nodeType != 1) {
            return null;
        }
        Element element = (Element)node;
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("STYLE")) {
            if (!StyleAdapterFactory.isTagAvailable(element.getOwnerDocument(), "STYLE")) {
                return null;
            }
            INodeAdapter adapter = notifier.getExistingAdapter(IStyleSheetAdapter.class);
            if (adapter != null) {
                return adapter;
            }
            StyleElementAdapter newAdapter = new StyleElementAdapter();
            newAdapter.setElement(element);
            notifier.addAdapter(newAdapter);
            return newAdapter;
        }
        if (tagName.equalsIgnoreCase("LINK")) {
            if (!StyleAdapterFactory.isTagAvailable(element.getOwnerDocument(), "LINK")) {
                return null;
            }
            INodeAdapter adapter = notifier.getExistingAdapter(IStyleSheetAdapter.class);
            if (adapter != null) {
                return adapter;
            }
            LinkElementAdapter newAdapter = new LinkElementAdapter();
            newAdapter.setElement(element);
            notifier.addAdapter(newAdapter);
            return newAdapter;
        }
        INodeAdapter adapter = notifier.getExistingAdapter(IStyleDeclarationAdapter.class);
        if (adapter != null) {
            return adapter;
        }
        if (!StyleAdapterFactory.isAttributeAvailable(element, "style")) {
            return null;
        }
        StyleAttrAdapter newAdapter = new StyleAttrAdapter();
        newAdapter.setElement(element);
        notifier.addAdapter(newAdapter);
        return newAdapter;
    }

    public static synchronized StyleAdapterFactory getInstance() {
        if (instance == null) {
            instance = new StyleAdapterFactory();
        }
        return instance;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == IStyleSheetAdapter.class || type == IStyleDeclarationAdapter.class || type == IStyleSheetListAdapter.class;
    }

    @Override
    public void release() {
    }

    private static boolean isTagAvailable(Document document, String elementName) {
        CMDocument cmdoc;
        CMNamedNodeMap map;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(document);
        return modelQuery != null && (CMElementDeclaration)(map = (cmdoc = modelQuery.getCorrespondingCMDocument(document)).getElements()).getNamedItem(elementName) != null;
    }

    private static boolean isAttributeAvailable(Element element, String attrName) {
        CMNamedNodeMap map;
        CMElementDeclaration decl;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(element.getOwnerDocument());
        return modelQuery != null && (decl = modelQuery.getCMElementDeclaration(element)) != null && (CMAttributeDeclaration)(map = decl.getAttributes()).getNamedItem(attrName) != null;
    }

    @Override
    public INodeAdapterFactory copy() {
        return StyleAdapterFactory.getInstance();
    }
}

