/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.core.nd.StreamHasher;
import org.eclipse.jdt.internal.core.nd.java.Package;

public class FileFingerprint {
    public static final long NEVER_MODIFIED = 0L;
    public static final long UNKNOWN = 1L;
    private static final long WORST_FILESYSTEM_TIMESTAMP_ACCURACY_MS = 2000L;
    private long time;
    private long hash;
    private long size;
    private static final FileFingerprint EMPTY = new FileFingerprint(0L, 0L, 0L);

    public static final FileFingerprint getEmpty() {
        return EMPTY;
    }

    public static final FileFingerprint create(IPath path, IProgressMonitor monitor) throws CoreException {
        return FileFingerprint.getEmpty().test(path, monitor).getNewFingerprint();
    }

    public FileFingerprint(long time, long size, long hash) {
        this.time = time;
        this.size = size;
        this.hash = hash;
    }

    public long getTime() {
        return this.time;
    }

    public long getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileFingerprint other = (FileFingerprint)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.time == other.time;
    }

    public boolean fileExists() {
        return !this.equals(EMPTY);
    }

    public FingerprintTestResult test(IPath path, IProgressMonitor monitor) throws CoreException {
        long hashCode;
        IFileStore store;
        IFileInfo fileInfo;
        long lastModified;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        long currentTime = System.currentTimeMillis();
        if (Math.abs(currentTime - (lastModified = (fileInfo = (store = EFS.getLocalFileSystem().getStore(path)).fetchInfo()).getLastModified())) < 2000L) {
            lastModified = 1L;
        }
        subMonitor.split(5);
        long fileSize = fileInfo.getLength();
        subMonitor.split(5);
        if (lastModified != 1L && lastModified == this.time && fileSize == this.size) {
            return new FingerprintTestResult(true, false, this);
        }
        try {
            hashCode = fileSize == 0L ? 0L : this.computeHashCode(path.toFile(), fileSize, (IProgressMonitor)subMonitor.split(90));
        }
        catch (IOException e) {
            throw new CoreException(Package.createStatus("An error occurred computing a hash code", e));
        }
        boolean matches = hashCode == this.hash && fileSize == this.size;
        FileFingerprint newFingerprint = new FileFingerprint(lastModified, fileSize, hashCode);
        return new FingerprintTestResult(matches, !this.equals(newFingerprint), newFingerprint);
    }

    private long computeHashCode(File toTest, long fileSize, IProgressMonitor monitor) throws IOException {
        int BUFFER_SIZE = 2048;
        char[] charBuffer = new char[2048];
        byte[] byteBuffer = new byte[4096];
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((int)(fileSize / 4096L)));
        StreamHasher hasher = new StreamHasher();
        try (FileInputStream inputStream = new FileInputStream(toTest);){
            while (true) {
                subMonitor.split(1);
                int bytesRead = this.readUntilBufferFull(inputStream, byteBuffer);
                if (bytesRead < byteBuffer.length) {
                    charBuffer = new char[(bytesRead + 1) / 2];
                    this.copyByteArrayToCharArray(charBuffer, byteBuffer, bytesRead);
                    hasher.addChunk(charBuffer);
                    break;
                }
                this.copyByteArrayToCharArray(charBuffer, byteBuffer, bytesRead);
                hasher.addChunk(charBuffer);
            }
        }
        catch (FileNotFoundException e) {
            return 0L;
        }
        return hasher.computeHash();
    }

    private void copyByteArrayToCharArray(char[] charBuffer, byte[] byteBuffer, int bytesToCopy) {
        int ch = 0;
        while (ch < bytesToCopy / 2) {
            char next;
            charBuffer[ch] = next = (char)(byteBuffer[ch * 2] + byteBuffer[ch * 2 + 1]);
            ++ch;
        }
        if (bytesToCopy % 2 != 0) {
            charBuffer[bytesToCopy / 2] = (char)byteBuffer[bytesToCopy - 1];
        }
    }

    int readUntilBufferFull(InputStream inputStream, byte[] buffer) throws IOException {
        int bytesRead = 0;
        while (bytesRead < buffer.length) {
            int thisRead = inputStream.read(buffer, bytesRead, buffer.length - bytesRead);
            if (thisRead == -1) {
                return bytesRead;
            }
            bytesRead += thisRead;
        }
        return bytesRead;
    }

    private static String getTimeString(long timestamp) {
        if (timestamp == 1L) {
            return "UNKNOWN";
        }
        if (timestamp == 0L) {
            return "NEVER_MODIFIED";
        }
        return Long.toString(timestamp);
    }

    public String toString() {
        return "FileFingerprint [time=" + FileFingerprint.getTimeString(this.time) + ", size=" + this.size + ", hash=" + this.hash + "]";
    }

    public static class FingerprintTestResult {
        private boolean matches;
        private boolean needsNewFingerprint;
        private FileFingerprint newFingerprint;

        public FingerprintTestResult(boolean matches, boolean needsNewFingerprint, FileFingerprint newFingerprint) {
            this.matches = matches;
            this.newFingerprint = newFingerprint;
            this.needsNewFingerprint = needsNewFingerprint;
        }

        public boolean needsNewFingerprint() {
            return this.needsNewFingerprint;
        }

        public boolean matches() {
            return this.matches;
        }

        public FileFingerprint getNewFingerprint() {
            return this.newFingerprint;
        }

        public String toString() {
            return "FingerprintTestResult [matches=" + this.matches + ", needsNewFingerprint=" + this.needsNewFingerprint + ", newFingerprint=" + this.newFingerprint + "]";
        }
    }
}

