/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.jdt.groovy.control.CharArrayReaderSource;
import org.codehaus.jdt.groovy.integration.EventHandler;
import org.codehaus.jdt.groovy.integration.ISupplementalIndexer;
import org.codehaus.jdt.groovy.integration.LanguageSupport;
import org.codehaus.jdt.groovy.integration.internal.BinaryGroovySupplementalIndexer;
import org.codehaus.jdt.groovy.integration.internal.GroovyEventHandler;
import org.codehaus.jdt.groovy.integration.internal.ISearchScopeExpander;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingCommentRecorderParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingCompletionParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingImportMatchLocatorParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingIndexingParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingMatchLocatorParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingSourceElementRequestorParser;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.util.CompilerUtils;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeRequestorFactory;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.search.matching.ImportMatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyLanguageSupport
implements LanguageSupport {
    private static final CompilerConfiguration CONFIG_SCRIPT_CONFIG = new CompilerConfiguration();
    public static ISearchScopeExpander searchScopeExpander;

    static {
        CONFIG_SCRIPT_CONFIG.addCompilationCustomizers(new ImportCustomizer().addStaticStars("org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"));
        CONFIG_SCRIPT_CONFIG.setDisabledGlobalASTTransformations(new HashSet<String>(Arrays.asList("org.codehaus.groovy.ast.builder.AstBuilderTransformation", "groovy.grape.GrabAnnotationTransformation")));
    }

    @Override
    public Parser getParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean parseLiteralExpressionsAsConstants, int variant) {
        if (variant == 1) {
            return new MultiplexingParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants);
        }
        if (variant == 2) {
            return new MultiplexingCommentRecorderParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants);
        }
        return new MultiplexingCommentRecorderParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants, false);
    }

    @Override
    public CompletionParser getCompletionParser(CompilerOptions compilerOptions, ProblemReporter problemReposrter, boolean storeExtraSourceEnds, IProgressMonitor monitor) {
        return new MultiplexingCompletionParser(compilerOptions, problemReposrter, storeExtraSourceEnds, monitor);
    }

    @Override
    public IndexingParser getIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        return new MultiplexingIndexingParser(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
    }

    @Override
    public MatchLocatorParser getMatchLocatorParserParser(ProblemReporter problemReporter, MatchLocator locator) {
        return new MultiplexingMatchLocatorParser(problemReporter, locator);
    }

    @Override
    public ImportMatchLocatorParser getImportMatchLocatorParserParser(ProblemReporter problemReporter, MatchLocator locator) {
        return new MultiplexingImportMatchLocatorParser(problemReporter, locator);
    }

    @Override
    public SourceElementParser getSourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, new DefaultProblemFactory());
        return new MultiplexingSourceElementRequestorParser(problemReporter, requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals);
    }

    @Override
    public Collection<String> getImplicitImportContainers(ICompilationUnit compilationUnit) {
        Collection implicitImportContainerNames = Arrays.stream(ResolveVisitor.DEFAULT_IMPORTS).map(p -> p.substring(0, p.length() - 1)).collect(Collectors.toList());
        ModuleNode module = ((GroovyCompilationUnit)compilationUnit).getModuleNode();
        if (module != null) {
            for (ImportNode starImport : module.getStarImports()) {
                if (starImport.getEnd() >= 1) continue;
                String packageName = starImport.getPackageName();
                packageName = packageName.substring(0, packageName.length() - 1);
                implicitImportContainerNames.add(packageName);
            }
        }
        return implicitImportContainerNames;
    }

    @Override
    public CompilationUnit newCompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        if (ContentTypeUtils.isGroovyLikeFileName(name)) {
            return new GroovyCompilationUnit(parent, name, owner);
        }
        return new CompilationUnit(parent, name, owner);
    }

    @Override
    public CompilationUnitDeclaration newCompilationUnitDeclaration(org.eclipse.jdt.internal.compiler.env.ICompilationUnit icu, ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        if (ContentTypeUtils.isGroovyLikeFileName(icu.getFileName())) {
            IFile eclipseFile;
            IWorkspace workspace;
            final String unitName = String.valueOf(icu.getFileName());
            CharArrayReaderSource unitSource = new CharArrayReaderSource(icu.getContents()){

                @Override
                public URI getURI() {
                    return URI.create("platform:/resource" + unitName);
                }
            };
            if (problemReporter.options.groovyCompilerConfigScript != null && (workspace = ResourcesPlugin.getWorkspace()) != null && workspace.getRoot() != null && (eclipseFile = workspace.getRoot().getFile((IPath)new Path(unitName))) != null && eclipseFile.getProject().isAccessible() && !JavaCore.create(eclipseFile.getProject()).isOnClasspath((IResource)eclipseFile)) {
                problemReporter.options.groovyCompilerConfigScript = null;
            }
            CompilerConfiguration compilerConfig = GroovyLanguageSupport.newCompilerConfiguration(problemReporter.options, problemReporter);
            GroovyClassLoader classLoader = null;
            GroovyErrorCollectorForJDT errorCollector = new GroovyErrorCollectorForJDT(compilerConfig);
            SourceUnit groovySourceUnit = new SourceUnit(unitName, unitSource, compilerConfig, classLoader, (ErrorCollector)errorCollector);
            org.codehaus.groovy.control.CompilationUnit gcu = new org.codehaus.groovy.control.CompilationUnit(compilerConfig);
            JDTResolver resolver = new JDTResolver(gcu);
            gcu.setResolveVisitor(resolver);
            gcu.addSource(groovySourceUnit);
            compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(icu.getContents());
            GroovyCompilationUnitDeclaration decl = new GroovyCompilationUnitDeclaration(problemReporter, compilationResult, sourceLength, gcu, groovySourceUnit, problemReporter.options);
            decl.processToPhase(3);
            if (decl.getModuleNode() != null) {
                decl.populateCompilationUnitDeclaration();
                TypeDeclaration[] typeDeclarationArray = decl.types;
                int n = decl.types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeDeclaration type = typeDeclarationArray[n2];
                    resolver.record((GroovyTypeDeclaration)type);
                    ++n2;
                }
            }
            return decl;
        }
        return new CompilationUnitDeclaration(problemReporter, compilationResult, sourceLength);
    }

    public static CompilerConfiguration newCompilerConfiguration(CompilerOptions compilerOptions, ProblemReporter problemReporter) {
        CompilerConfiguration config = new CompilerConfiguration();
        if (compilerOptions.targetJDK > CompilerOptions.versionToJdkLevel(config.getTargetBytecode())) {
            long target = Math.min(compilerOptions.targetJDK, CompilerOptions.versionToJdkLevel(CompilerConfiguration.ALLOWED_JDKS[CompilerConfiguration.ALLOWED_JDKS.length - 1]));
            config.setTargetBytecode(CompilerOptions.versionFromJdkLevel(target));
        }
        if (compilerOptions.defaultEncoding != null && !compilerOptions.defaultEncoding.isEmpty()) {
            config.setSourceEncoding(compilerOptions.defaultEncoding);
        }
        config.setPreviewFeatures(compilerOptions.enablePreviewFeatures);
        config.setParameters(compilerOptions.produceMethodParameters);
        if (compilerOptions.buildGroovyFiles > 1 && compilerOptions.groovyCompilerConfigScript != null) {
            Binding binding = new Binding();
            binding.setVariable("configuration", config);
            GroovyShell shell = new GroovyShell(binding, CONFIG_SCRIPT_CONFIG);
            try {
                File configScript = new File(compilerOptions.groovyCompilerConfigScript);
                if (!configScript.isAbsolute() && compilerOptions.groovyProjectName != null) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(compilerOptions.groovyProjectName);
                    configScript = new File(project.getLocation().append(configScript.getPath()).toOSString());
                }
                shell.evaluate(configScript);
            }
            catch (Exception e) {
                int severity = 1;
                CompilationResult compilationResult = null;
                if (problemReporter.referenceContext != null) {
                    severity = 0;
                    compilationResult = problemReporter.referenceContext.compilationResult();
                }
                String[] arguments = new String[]{compilerOptions.groovyCompilerConfigScript, e.toString()};
                problemReporter.handle(536871614, arguments, 0, arguments, severity, 0, 0, problemReporter.referenceContext, compilationResult);
            }
        }
        if ((compilerOptions.groovyFlags & 2) != 0) {
            config.getOptimizationOptions().put("indy", Boolean.TRUE);
        }
        return config;
    }

    public static GroovyClassLoader newGroovyClassLoader(IJavaProject project, ClassLoader parentLoader) {
        Map<String, String> options = project.getOptions(true);
        CompilerUtils.configureOptionsBasedOnNature(options, project);
        GroovyClassLoaderFactory factory = new GroovyClassLoaderFactory(new CompilerOptions(options), null);
        CompilerConfiguration config = CompilerConfiguration.DEFAULT;
        GroovyClassLoader projectLoader = factory.getGroovyClassLoaders(config)[1];
        MultiParentClassLoader multiParentLoader = new MultiParentClassLoader(project.getElementName(), new URL[0], new ClassLoader[]{projectLoader, parentLoader});
        return new GroovyClassLoader(multiParentLoader);
    }

    @Override
    public boolean isInterestingProject(IProject project) {
        return GroovyNature.hasGroovyNature(project);
    }

    @Override
    public boolean isSourceFile(String fileName, boolean isInterestingProject) {
        if (isInterestingProject) {
            return Util.isJavaLikeFileName(fileName);
        }
        return ContentTypeUtils.isJavaLikeButNotGroovyLikeFileName(fileName);
    }

    @Override
    public boolean isInterestingSourceFile(String fileName) {
        return ContentTypeUtils.isGroovyLikeFileName(fileName);
    }

    @Override
    public boolean maybePerformDelegatedSearch(PossibleMatch possibleMatch, SearchPattern pattern, SearchRequestor requestor) {
        ITypeRequestor typeRequestor;
        if (possibleMatch.openable != null && possibleMatch.openable.exists() && (typeRequestor = new TypeRequestorFactory().createRequestor(possibleMatch, pattern, requestor)) != null) {
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(possibleMatch);
            visitor.visitCompilationUnit(typeRequestor);
            return true;
        }
        return false;
    }

    @Override
    public EventHandler getEventHandler() {
        return new GroovyEventHandler();
    }

    @Override
    public void filterNonSourceMembers(BinaryType binaryType) {
        try {
            IJavaElement[] childrenArr = binaryType.getChildren();
            ArrayList<IJavaElement> children = new ArrayList<IJavaElement>(Arrays.asList(childrenArr));
            LinkedList<BinaryMember> removedChildren = new LinkedList<BinaryMember>();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                BinaryMember binaryChild;
                ISourceRange iSourceRange;
                IJavaElement child = (IJavaElement)childIter.next();
                if (!(child instanceof BinaryMember) || (iSourceRange = (binaryChild = (BinaryMember)child).getSourceRange()) != null && iSourceRange.getOffset() != -1) continue;
                removedChildren.add(binaryChild);
                childIter.remove();
            }
            JavaElement[] newChildrenArr = children.toArray(new JavaElement[children.size()]);
            Object classFileInfo = ((ClassFile)binaryType.getParent()).getElementInfo();
            ReflectionUtils.setPrivateField(classFileInfo.getClass(), "binaryChildren", classFileInfo, newChildrenArr);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            for (JavaElement javaElement : removedChildren) {
                if (javaElement instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)javaElement.getParent());
                    continue;
                }
                manager.removeInfoAndChildren(javaElement);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IJavaSearchScope expandSearchScope(IJavaSearchScope scope, SearchPattern pattern, SearchRequestor requestor) {
        if (searchScopeExpander != null) {
            return searchScopeExpander.expandSearchScope(scope, pattern, requestor);
        }
        return scope;
    }

    @Override
    public boolean isInterestingBinary(BinaryType type, IBinaryType typeInfo) {
        return this.isInterestingProject(type.getJavaProject().getProject()) && ContentTypeUtils.isGroovyLikeFileName(type.sourceFileName(typeInfo));
    }

    @Override
    public IJavaElement[] binaryCodeSelect(ClassFile classFile, int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        GroovyClassFileWorkingCopy binaryUnit = new GroovyClassFileWorkingCopy(classFile, owner);
        return binaryUnit.codeSelect(offset, length, owner);
    }

    @Override
    public ISupplementalIndexer getSupplementalIndexer() {
        return new BinaryGroovySupplementalIndexer();
    }
}

