/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import groovy.transform.CompileStatic;
import groovy.transform.Generated;
import groovyjarjarasm.asm.MethodVisitor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.MethodReferenceExpressionWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.AbstractFunctionalInterfaceWriter;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesMethodReferenceExpressionWriter
extends MethodReferenceExpressionWriter
implements AbstractFunctionalInterfaceWriter {
    private static final String METHODREF_EXPR_INSTANCE = "__METHODREF_EXPR_INSTANCE";

    public StaticTypesMethodReferenceExpressionWriter(WriterController controller) {
        super(controller);
    }

    @Override
    public void writeMethodReferenceExpression(MethodReferenceExpression methodReferenceExpression) {
        MethodNode methodRefMethod;
        ClassNode functionalInterfaceType = this.getFunctionalInterfaceType(methodReferenceExpression);
        if (null == functionalInterfaceType) {
            super.writeMethodReferenceExpression(methodReferenceExpression);
            return;
        }
        ClassNode redirect = functionalInterfaceType.redirect();
        if (!ClassHelper.isFunctionalInterface(redirect)) {
            super.writeMethodReferenceExpression(methodReferenceExpression);
            return;
        }
        MethodNode abstractMethodNode = ClassHelper.findSAM(redirect);
        String abstractMethodDesc = this.createMethodDescriptor(abstractMethodNode);
        ClassNode classNode = this.controller.getClassNode();
        boolean isInterface = classNode.isInterface();
        Expression typeOrTargetRef = methodReferenceExpression.getExpression();
        ClassNode typeOrTargetRefType = typeOrTargetRef.getType();
        String methodRefName = methodReferenceExpression.getMethodName().getText();
        ClassNode[] methodReferenceParamTypes = (ClassNode[])methodReferenceExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        Parameter[] parametersWithExactType = this.createParametersWithExactType(abstractMethodNode, methodReferenceParamTypes);
        boolean isConstructorReference = this.isConstructorReference(methodRefName);
        if (isConstructorReference) {
            methodRefName = this.genSyntheticMethodNameForConstructorReference();
            methodRefMethod = this.addSyntheticMethodForConstructorReference(methodRefName, typeOrTargetRefType, parametersWithExactType);
        } else {
            methodRefMethod = this.findMethodRefMethod(methodRefName, parametersWithExactType, typeOrTargetRef);
        }
        this.validate(methodReferenceExpression, typeOrTargetRef, typeOrTargetRefType, methodRefName, parametersWithExactType, methodRefMethod);
        if (StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(methodRefMethod)) {
            ExtensionMethodNode extensionMethodNode = (ExtensionMethodNode)methodRefMethod;
            methodRefMethod = extensionMethodNode.getExtensionMethodNode();
            if (extensionMethodNode.isStaticExtension()) {
                methodRefMethod = this.addSyntheticMethodForDGSM(methodRefMethod);
            }
            ClassExpression classExpression = new ClassExpression(methodRefMethod.getDeclaringClass());
            classExpression.setSourcePosition(typeOrTargetRef);
            typeOrTargetRef = classExpression;
            typeOrTargetRefType = typeOrTargetRef.getType();
        }
        methodRefMethod.putNodeMetaData("__ORIGINAL_PARAMETERS_WITH_EXACT_TYPE", parametersWithExactType);
        MethodVisitor mv = this.controller.getMethodVisitor();
        boolean isClassExpr = StaticTypesMethodReferenceExpressionWriter.isClassExpr(typeOrTargetRef);
        if (!isClassExpr) {
            if (isConstructorReference) {
                throw new RuntimeParserException("Constructor reference must be className::new", methodReferenceExpression);
            }
            if (methodRefMethod.isStatic()) {
                ClassExpression classExpression = new ClassExpression(typeOrTargetRefType);
                classExpression.setSourcePosition(typeOrTargetRef);
                typeOrTargetRef = classExpression;
                isClassExpr = true;
            }
            if (!isClassExpr) {
                typeOrTargetRef.visit(this.controller.getAcg());
            }
        }
        mv.visitInvokeDynamicInsn(abstractMethodNode.getName(), this.createAbstractMethodDesc(functionalInterfaceType, typeOrTargetRef), this.createBootstrapMethod(isInterface), this.createBootstrapMethodArguments(abstractMethodDesc, methodRefMethod.isStatic() || isConstructorReference ? 6 : 5, isConstructorReference ? this.controller.getClassNode() : typeOrTargetRefType, methodRefMethod));
        if (isClassExpr) {
            this.controller.getOperandStack().push(redirect);
        } else {
            this.controller.getOperandStack().replace(redirect, 1);
        }
    }

    private void validate(MethodReferenceExpression methodReferenceExpression, Expression typeOrTargetRef, ClassNode typeOrTargetRefType, String methodRefName, Parameter[] parametersWithExactType, MethodNode methodRefMethod) {
        if (null == methodRefMethod) {
            throw new RuntimeParserException("Failed to find the expected method[" + methodRefName + "(" + Arrays.stream(parametersWithExactType).map(e -> e.getType().getName()).collect(Collectors.joining(",")) + ")] in the type[" + typeOrTargetRefType.getName() + "]", methodReferenceExpression);
        }
        if (parametersWithExactType.length > 0 && StaticTypesMethodReferenceExpressionWriter.isTypeReferingInstanceMethod(typeOrTargetRef, methodRefMethod)) {
            Class firstParameterClass;
            Parameter firstParameter = parametersWithExactType[0];
            Class typeOrTargetClass = typeOrTargetRef.getType().getTypeClass();
            if (!typeOrTargetClass.isAssignableFrom(firstParameterClass = firstParameter.getType().getTypeClass())) {
                throw new RuntimeParserException("Invalid receiver type: " + firstParameterClass + " is not compatible with " + typeOrTargetClass, typeOrTargetRef);
            }
        }
    }

    private static boolean isExtensionMethod(MethodNode methodRefMethod) {
        return methodRefMethod instanceof ExtensionMethodNode;
    }

    private MethodNode addSyntheticMethodForDGSM(MethodNode mn) {
        Parameter[] parameters = StaticTypesMethodReferenceExpressionWriter.removeFirstParameter(mn.getParameters());
        ArgumentListExpression args = GeneralUtils.args(parameters);
        args.getExpressions().add(0, ConstantExpression.NULL);
        MethodNode syntheticMethodNode = this.controller.getClassNode().addSyntheticMethod("dgsm$$" + mn.getParameters()[0].getType().getName().replace(".", "$") + "$$" + mn.getName(), 4122, mn.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.callX((Expression)new ClassExpression(mn.getDeclaringClass()), mn.getName(), (Expression)args))));
        syntheticMethodNode.addAnnotation(new AnnotationNode(ClassHelper.make(Generated.class)));
        syntheticMethodNode.addAnnotation(new AnnotationNode(ClassHelper.make(CompileStatic.class)));
        return syntheticMethodNode;
    }

    private MethodNode addSyntheticMethodForConstructorReference(String syntheticMethodName, ClassNode returnType, Parameter[] parametersWithExactType) {
        ArgumentListExpression ctorArgs = GeneralUtils.args(parametersWithExactType);
        MethodNode syntheticMethodNode = this.controller.getClassNode().addSyntheticMethod(syntheticMethodName, 4122, returnType, parametersWithExactType, ClassNode.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.returnS(returnType.isArray() ? new ArrayExpression(ClassHelper.make(ArrayTypeUtils.elementType(returnType.getTypeClass())), null, ctorArgs.getExpressions()) : GeneralUtils.ctorX(returnType, ctorArgs))));
        syntheticMethodNode.addAnnotation(new AnnotationNode(ClassHelper.make(Generated.class)));
        syntheticMethodNode.addAnnotation(new AnnotationNode(ClassHelper.make(CompileStatic.class)));
        return syntheticMethodNode;
    }

    private String genSyntheticMethodNameForConstructorReference() {
        return this.controller.getContext().getNextConstructorReferenceSyntheticMethodName(this.controller.getMethodNode());
    }

    private boolean isConstructorReference(String methodRefName) {
        return "new".equals(methodRefName);
    }

    private static boolean isClassExpr(Expression methodRef) {
        return methodRef instanceof ClassExpression;
    }

    private String createAbstractMethodDesc(ClassNode functionalInterfaceType, Expression methodRef) {
        LinkedList<Parameter> methodReferenceSharedVariableList = new LinkedList<Parameter>();
        if (!StaticTypesMethodReferenceExpressionWriter.isClassExpr(methodRef)) {
            ClassNode methodRefTargetType = methodRef.getType();
            this.prependParameter(methodReferenceSharedVariableList, METHODREF_EXPR_INSTANCE, methodRefTargetType);
        }
        return BytecodeHelper.getMethodDescriptor(functionalInterfaceType.redirect(), methodReferenceSharedVariableList.toArray(Parameter.EMPTY_ARRAY));
    }

    private Parameter[] createParametersWithExactType(MethodNode abstractMethodNode, ClassNode[] inferredParameterTypes) {
        Parameter[] originalParameters = abstractMethodNode.getParameters();
        Parameter[] parameters = GeneralUtils.cloneParams(originalParameters);
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            ClassNode parameterType = parameter.getType();
            ClassNode inferredType = inferredParameterTypes[i];
            if (null == inferredType) continue;
            ClassNode type = this.convertParameterType(parameterType, inferredType);
            parameter.setType(type);
            parameter.setOriginType(type);
        }
        return parameters;
    }

    private MethodNode findMethodRefMethod(String methodRefName, Parameter[] abstractMethodParameters, Expression typeOrTargetRef) {
        ClassNode typeOrTargetRefType = typeOrTargetRef.getType();
        List<MethodNode> methodNodeList = typeOrTargetRefType.getMethods(methodRefName);
        Set<MethodNode> dgmMethodNodeSet = StaticTypeCheckingSupport.findDGMMethodsForClassNode(MetaClassRegistryImpl.class.getClassLoader(), typeOrTargetRefType, methodRefName);
        LinkedList<MethodNode> allMethodNodeList = new LinkedList<MethodNode>(methodNodeList);
        allMethodNodeList.addAll(dgmMethodNodeSet);
        ClassNode classNode = this.controller.getClassNode();
        LinkedList<MethodNode> candidates = new LinkedList<MethodNode>();
        for (MethodNode mn : StaticTypeCheckingSupport.filterMethodsByVisibility(allMethodNodeList, classNode)) {
            Parameter[] methodParameters;
            Parameter[] parameters = abstractMethodParameters;
            if (StaticTypesMethodReferenceExpressionWriter.isTypeReferingInstanceMethod(typeOrTargetRef, mn)) {
                if (0 == abstractMethodParameters.length) continue;
                parameters = StaticTypesMethodReferenceExpressionWriter.removeFirstParameter(abstractMethodParameters);
            }
            if (!ParameterUtils.parametersCompatible(parameters, methodParameters = StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn) ? StaticTypesMethodReferenceExpressionWriter.removeFirstParameter(((ExtensionMethodNode)mn).getExtensionMethodNode().getParameters()) : mn.getParameters())) continue;
            candidates.add(mn);
        }
        return this.chooseMethodRefMethodCandidate(typeOrTargetRef, candidates);
    }

    private static Parameter[] removeFirstParameter(Parameter[] parameters) {
        return (Parameter[])Arrays.stream(parameters).skip(1L).toArray(Parameter[]::new);
    }

    private static boolean isTypeReferingInstanceMethod(Expression typeOrTargetRef, MethodNode mn) {
        return (!mn.isStatic() || StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn) && !((ExtensionMethodNode)mn).isStaticExtension()) && StaticTypesMethodReferenceExpressionWriter.isClassExpr(typeOrTargetRef);
    }

    private MethodNode chooseMethodRefMethodCandidate(Expression methodRef, List<MethodNode> candidates) {
        if (1 == candidates.size()) {
            return candidates.get(0);
        }
        return candidates.stream().map(e -> Tuple.tuple(e, StaticTypesMethodReferenceExpressionWriter.matchingScore(e, methodRef))).min((t1, t2) -> Integer.compare((Integer)t2.getV2(), (Integer)t1.getV2())).map(Tuple2::getV1).orElse(null);
    }

    private static Integer matchingScore(MethodNode mn, Expression typeOrTargetRef) {
        ClassNode typeOrTargetRefType = typeOrTargetRef.getType();
        int score = 9;
        for (ClassNode cn = mn.getDeclaringClass(); null != cn && !cn.equals(typeOrTargetRefType); cn = cn.getSuperClass()) {
            --score;
        }
        if (score < 0) {
            score = 0;
        }
        score *= 10;
        boolean isClassExpr = StaticTypesMethodReferenceExpressionWriter.isClassExpr(typeOrTargetRef);
        boolean isStaticMethod = mn.isStatic();
        if (isClassExpr && isStaticMethod || !isClassExpr && !isStaticMethod) {
            score += 9;
        }
        if (StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn)) {
            score += 100;
        }
        return score;
    }
}

