/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base;

import com.diffplug.spotless.extra.eclipse.base.service.HiddenEnvironment;
import com.diffplug.spotless.extra.eclipse.base.service.NoContentTypeSpecificHandling;
import com.diffplug.spotless.extra.eclipse.base.service.NoDebugging;
import com.diffplug.spotless.extra.eclipse.base.service.NoEclipsePreferences;
import com.diffplug.spotless.extra.eclipse.base.service.SingleSlf4JService;
import com.diffplug.spotless.extra.eclipse.base.service.TemporaryLocation;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.service.log.LogLevel;

public interface SpotlessEclipseServiceConfig {
    public void set(String var1, String var2);

    default public void set(Map<String, String> properties) {
        properties.forEach((k, v) -> this.set((String)k, (String)v));
    }

    public <S> void add(Class<S> var1, S var2);

    default public void hideEnvironment() {
        this.add(EnvironmentInfo.class, new HiddenEnvironment());
    }

    default public void ignoreContentType() {
        this.add(IContentTypeManager.class, new NoContentTypeSpecificHandling());
    }

    default public void disableDebugging() {
        this.add(DebugOptions.class, new NoDebugging());
    }

    default public void ignoreUnsupportedPreferences() {
        this.add(IPreferencesService.class, new NoEclipsePreferences());
    }

    default public void useTemporaryLocations() {
        this.add(Location.class, new TemporaryLocation());
    }

    default public void changeSystemLineSeparator() {
        System.setProperty("line.separator", "\n");
    }

    default public void useSlf4J(String loggerName) {
        this.useSlf4J(loggerName, (s, l) -> s);
    }

    default public void useSlf4J(String loggerName, BiFunction<String, LogLevel, String> messageCustomizer) {
        SingleSlf4JService slf4jServce = new SingleSlf4JService(loggerName, messageCustomizer);
        this.add(ExtendedLogService.class, slf4jServce);
        this.add(ExtendedLogReaderService.class, slf4jServce);
        slf4jServce.debug("Initialized Eclipse logging service.");
    }

    default public void applyDefault() {
        this.hideEnvironment();
        this.ignoreContentType();
        this.disableDebugging();
        this.ignoreUnsupportedPreferences();
        this.useTemporaryLocations();
        this.changeSystemLineSeparator();
    }
}

