/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.common.io.ByteSource;
import com.diffplug.common.io.Resources;
import com.diffplug.gradle.FileMisc;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;

class BrandingProductPlugin {
    static final ImmutableList<String> template;
    private static final int MESSAGE_HEIGHT = 20;
    private static final int MESSAGE_MARGIN = 7;
    private static final int MESSAGE_VOFFSET = 40;
    private static final int PROGRESS_HEIGHT = 10;
    private static final int PROGRESS_MARGIN = 2;
    private static final String eclipse = "eclipse";
    private static final String dot_png = ".png";
    static final int RESOLUTION_UNCHANGED = -1;

    BrandingProductPlugin() {
    }

    public static BufferedImage getGoomphIcon() throws IOException {
        return BrandingProductPlugin.readImg("goomph_icon.png");
    }

    public static BufferedImage getGoomphSplash() throws IOException {
        return BrandingProductPlugin.readImg("goomph_splash.png");
    }

    private static BufferedImage readImg(String path) throws IOException {
        ByteSource source = Resources.asByteSource((URL)BrandingProductPlugin.class.getResource(path));
        try (InputStream stream = source.openBufferedStream();){
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
    }

    private static String rect(int x, int y, int width, int height) {
        return x + "," + y + "," + width + "," + height;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void create(File root, BufferedImage splash, BufferedImage icon, String name, String perspective) throws IOException {
        String startupMessageRect = BrandingProductPlugin.rect(7, splash.getHeight() - 40, splash.getWidth() - 14, 20);
        String startupProgressRect = BrandingProductPlugin.rect(2, splash.getHeight() - 2 - 10, splash.getWidth() - 4, 10);
        ImmutableMap map = ImmutableMap.of((Object)"plugin.xml", str -> str.replace("%name%", name).replace("%startupMessageRect%", startupMessageRect).replace("%startupProgressRect%", startupProgressRect), (Object)"plugin_customization.ini", str -> str.replace("org.eclipse.jdt.ui.JavaPerspective", perspective));
        FileMisc.cleanDir(root);
        Objects.requireNonNull(splash);
        icon = BrandingProductPlugin.makeSquare(icon);
        for (String subpath : template) {
            if (subpath.equals("splash.bmp")) {
                BrandingProductPlugin.writeImage(new File(root, subpath), splash, -1, "BMP");
                continue;
            }
            if (subpath.startsWith(eclipse) && subpath.endsWith(dot_png)) {
                String number = subpath.substring(eclipse.length(), subpath.length() - dot_png.length());
                int resolution = Integer.parseInt(number);
                BrandingProductPlugin.writeImage(new File(root, subpath), icon, resolution, "PNG");
                continue;
            }
            String templateValue = Resources.toString((URL)BrandingProductPlugin.class.getResource(subpath), (Charset)StandardCharsets.UTF_8);
            Function function = (Function)map.getOrDefault((Object)subpath, Function.identity());
            String content = (String)function.apply(templateValue);
            Path path = root.toPath().resolve(subpath);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private static BufferedImage makeSquare(BufferedImage input) {
        if (input.getHeight() == input.getWidth()) {
            return input;
        }
        int max = Math.max(input.getHeight(), input.getWidth());
        int dx = (max - input.getWidth()) / 2;
        int dy = (max - input.getHeight()) / 2;
        return BrandingProductPlugin.createImg(max, max, input.getType(), graphics -> graphics.drawImage(input, dx, dy, null));
    }

    private static void writeImage(File target, BufferedImage src, int resolution, String format) throws IOException {
        BufferedImage resultImage = resolution == -1 ? src : BrandingProductPlugin.createImg(resolution, resolution, src.getType(), creator -> {
            Image image = src.getScaledInstance(resolution, resolution, 4);
            creator.drawImage(image, 0, 0, null);
        });
        boolean wrote = ImageIO.write((RenderedImage)resultImage, format, target);
        if (!wrote) {
            BufferedImage otherFormat = BrandingProductPlugin.createImg(resultImage.getWidth(), resultImage.getHeight(), 1, graphics -> graphics.drawImage(resultImage, 0, 0, null));
            Preconditions.checkArgument((boolean)ImageIO.write((RenderedImage)otherFormat, format, target), (String)"Couldn't write %s", (Object[])new Object[]{target});
        }
    }

    private static BufferedImage createImg(int width, int height, int type, Consumer<Graphics2D> creator) {
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics2D graphics = image.createGraphics();
        creator.accept(graphics);
        graphics.dispose();
        return image;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"META-INF/MANIFEST.MF");
        builder.add((Object)"LegacyIDE.e4xmi");
        builder.add((Object)"plugin.properties");
        builder.add((Object)"plugin.xml");
        builder.add((Object)"plugin_customization.ini");
        builder.add((Object)"plugin_customization.properties");
        builder.add((Object)"eclipse256.png");
        builder.add((Object)"eclipse128.png");
        builder.add((Object)"eclipse64.png");
        builder.add((Object)"eclipse48.png");
        builder.add((Object)"eclipse32.png");
        builder.add((Object)"eclipse16.png");
        builder.add((Object)"splash.bmp");
        template = builder.build();
    }
}

