/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Lists;
import com.diffplug.common.swt.os.OS;
import com.diffplug.gradle.FileMisc;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CmdLine {
    private List<Throwing.Runnable> actions = Lists.newArrayList();
    private boolean echoCmd = true;
    private boolean echoOutput = true;
    private static final int EXIT_VALUE_SUCCESS = 0;

    public void echoCmd(boolean echoCmd) {
        this.echoCmd = echoCmd;
    }

    public void echoOutput(boolean echoOutput) {
        this.echoOutput = echoOutput;
    }

    public void cmd(String cmd) {
        this.cmd(new File(System.getProperty("user.dir")), cmd);
    }

    public void cmd(File workingDir, String cmd) {
        this.run(() -> {
            try {
                CmdLine.runCmd(workingDir, cmd, this.echoCmd, this.echoOutput);
            }
            catch (IOException e) {
                throw new RuntimeException("cmd: " + cmd + "\n" + "dir: " + workingDir.getAbsolutePath(), e);
            }
        });
    }

    public void rm(File fileOrDir) {
        this.run(() -> {
            if (fileOrDir.exists()) {
                FileMisc.forceDelete(fileOrDir);
            }
        });
    }

    public void copy(File src, File dst) {
        this.run(() -> {
            if (!src.exists()) {
                throw new IllegalArgumentException("copy failed: " + src.getAbsolutePath() + " does not exist.");
            }
            if (src.isDirectory()) {
                FileUtils.copyDirectory((File)src, (File)dst);
            } else {
                FileUtils.copyFile((File)src, (File)dst);
            }
        });
    }

    public void mv(File src, File dst) {
        this.run(() -> {
            if (!src.exists()) {
                throw new IllegalArgumentException("mv failed: " + src.getAbsolutePath() + " does not exist.");
            }
            if (src.isDirectory()) {
                FileUtils.moveDirectory((File)src, (File)dst);
            } else {
                FileUtils.moveFile((File)src, (File)dst);
            }
        });
    }

    public void run(Throwing.Runnable action) {
        this.actions.add(action);
    }

    public void performActions() throws Throwable {
        for (Throwing.Runnable action : this.actions) {
            action.run();
        }
    }

    public static Result runCmd(String cmd) throws IOException {
        return CmdLine.runCmd(new File(System.getProperty("user.dir")), cmd);
    }

    public static Result runCmd(File directory, String cmd) throws IOException {
        return CmdLine.runCmd(directory, cmd, true, true);
    }

    /*
     * Exception decompiling
     */
    public static Result runCmd(File directory, String cmd, boolean echoCmd, boolean echoOutput) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> getPlatformCmds(String cmd) {
        if (OS.getNative().isWindows()) {
            return Arrays.asList("cmd", "/c", cmd);
        }
        return Arrays.asList("/bin/sh", "-c", cmd);
    }

    public static class Result {
        public final File directory;
        public final String cmd;
        public final ImmutableList<String> output;
        public final ImmutableList<String> error;

        public Result(File directory, String cmd, ImmutableList<String> output, ImmutableList<String> error) {
            this.directory = directory;
            this.cmd = cmd;
            this.output = output;
            this.error = error;
        }
    }
}

