/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.StringPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OrderingConstraints<T> {
    final List<T> requires = new ArrayList<T>();
    final List<T> before = new ArrayList<T>();
    final List<T> after = new ArrayList<T>();

    public void require(T id) {
        this.requires.add(id);
    }

    public void beforeIfPresent(T id) {
        this.before.add(id);
    }

    public void afterIfPresent(T id) {
        this.after.add(id);
    }

    public void before(T id) {
        this.require(id);
        this.beforeIfPresent(id);
    }

    public void after(T id) {
        this.require(id);
        this.afterIfPresent(id);
    }

    public static <T> List<T> satisfy(List<T> input, Function<? super T, ? extends OrderingConstraints<T>> constraintSupplier) {
        return OrderingConstraints.satisfy(input, Function.identity(), constraintSupplier);
    }

    public static <T, C> List<T> satisfy(List<T> input, Function<? super T, ? extends C> idFunction, Function<? super T, ? extends OrderingConstraints<C>> constraintSupplier) {
        ConstrainedList<T, C> constrained = new ConstrainedList<T, C>();
        for (T value : input) {
            constrained.add(value, idFunction.apply(value), constraintSupplier.apply(value));
        }
        return constrained.satisfyAndGet().stream().map(entry -> entry.value).collect(Collectors.toList());
    }

    private static class ConstrainedList<T, ID> {
        Set<ID> ids = new HashSet<ID>();
        List<ConstrainedEntry<T, ID>> values = new ArrayList<ConstrainedEntry<T, ID>>();

        private ConstrainedList() {
        }

        public void add(T value, ID id, OrderingConstraints<ID> constraints) {
            Preconditions.checkArgument((boolean)this.ids.add(id), (String)"Multiple ids for %s", (Object[])new Object[]{id});
            ConstrainedEntry<T, ID> entry = new ConstrainedEntry<T, ID>(value, id, constraints);
            this.values.add(entry);
        }

        public List<ConstrainedEntry<T, ID>> satisfyAndGet() {
            for (int i = 0; i < this.values.size(); ++i) {
                ConstrainedEntry<T, ID> entry = this.values.get(i);
                for (Object required : entry.constraints.requires) {
                    if (this.ids.contains(required)) continue;
                    throw new IllegalArgumentException(entry.id + " requires " + required + ", but it is not present.");
                }
            }
            int numTries = 0;
            while (!this.isOrdered()) {
                if (++numTries < this.values.size() * 10) continue;
                throw new IllegalArgumentException("Could not satisfy order constraints:\n" + this.orderConstraintsAsString());
            }
            return Collections.unmodifiableList(this.values);
        }

        private int indexOf(ID id) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (!this.values.get((int)i).id.equals(id)) continue;
                return i;
            }
            return -1;
        }

        private String orderConstraintsAsString() {
            return StringPrinter.buildString(printer -> {
                for (ConstrainedEntry<T, ID> entry : this.values) {
                    entry.constraints.before.forEach(before -> printer.println(entry.id + " must be before " + before));
                    entry.constraints.after.forEach(after -> printer.println(entry.id + " must be after " + after));
                }
            });
        }

        private boolean isOrdered() {
            for (int i = 0; i < this.values.size(); ++i) {
                ConstrainedEntry<T, ID> entry = this.values.get(i);
                for (Object before : entry.constraints.before) {
                    int beforeIdx = this.indexOf(before);
                    if (beforeIdx == -1 || i < beforeIdx) continue;
                    this.values.remove(i);
                    this.values.add(beforeIdx, entry);
                    return false;
                }
                for (Object after : entry.constraints.after) {
                    int afterIdx = this.indexOf(after);
                    if (afterIdx == -1 || i > afterIdx) continue;
                    this.values.remove(i);
                    this.values.add(afterIdx, entry);
                    return false;
                }
            }
            return true;
        }
    }

    private static class ConstrainedEntry<T, ID> {
        final T value;
        final ID id;
        final OrderingConstraints<ID> constraints;

        ConstrainedEntry(T value, ID id, OrderingConstraints<ID> constraints) {
            this.value = Objects.requireNonNull(value);
            this.id = Objects.requireNonNull(id);
            this.constraints = Objects.requireNonNull(constraints);
        }
    }
}

