/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.ConverterNullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ConverterNullableImp {
    private ConverterNullableImp() {
    }

    static class ReverseConverter<A, B>
    implements ConverterNullable<A, B>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final ConverterNullable<B, A> original;

        ReverseConverter(ConverterNullable<B, A> original) {
            this.original = original;
        }

        @Override
        public B convert(A a) {
            return this.original.revert(a);
        }

        @Override
        public A revert(B b) {
            return this.original.convert(b);
        }

        @Override
        public ConverterNullable<B, A> reverse() {
            return this.original;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof ReverseConverter) {
                ReverseConverter that = (ReverseConverter)object;
                return this.original.equals(that.original);
            }
            return false;
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        public String toString() {
            return this.original.toString() + ".reverse()";
        }
    }

    static final class ConverterComposition<A, B, C>
    implements ConverterNullable<A, C>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final ConverterNullable<A, B> first;
        final ConverterNullable<B, C> second;

        ConverterComposition(ConverterNullable<A, B> first, ConverterNullable<B, C> second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public C convert(A a) {
            return this.second.convert(this.first.convert(a));
        }

        @Override
        public A revert(C c) {
            return this.first.revert(this.second.revert(c));
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof ConverterComposition) {
                ConverterComposition that = (ConverterComposition)object;
                return this.first.equals(that.first) && this.second.equals(that.second);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public String toString() {
            return this.first + ".andThen(" + this.second + ")";
        }
    }

    static final class FunctionBasedConverter<A, B>
    implements ConverterNullable<A, B>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Function<? super A, ? extends B> forwardFunction;
        final Function<? super B, ? extends A> backwardFunction;
        final String name;

        FunctionBasedConverter(Function<? super A, ? extends B> forwardFunction, Function<? super B, ? extends A> backwardFunction, String name) {
            this.forwardFunction = Objects.requireNonNull(forwardFunction);
            this.backwardFunction = Objects.requireNonNull(backwardFunction);
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public B convert(A a) {
            return this.forwardFunction.apply(a);
        }

        @Override
        public A revert(B b) {
            return this.backwardFunction.apply(b);
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof FunctionBasedConverter) {
                FunctionBasedConverter that = (FunctionBasedConverter)object;
                return this.forwardFunction.equals(that.forwardFunction) && this.backwardFunction.equals(that.backwardFunction);
            }
            return false;
        }

        public int hashCode() {
            return this.forwardFunction.hashCode() * 31 + this.backwardFunction.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

