/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.BoxImp;
import com.diffplug.common.base.Converter;
import com.diffplug.common.base.ConverterNullable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface Box<T>
extends Supplier<T>,
Consumer<T> {
    public void set(T var1);

    @Override
    @Deprecated
    default public void accept(T value) {
        this.set(value);
    }

    default public T modify(Function<? super T, ? extends T> mutator) {
        T modified = mutator.apply(this.get());
        this.set(modified);
        return modified;
    }

    default public <R> Box<R> map(Converter<T, R> converter) {
        return new BoxImp.Mapped<T, R>(this, converter);
    }

    public static <T> Box<T> of(T value) {
        return new BoxImp.Default<T>(value);
    }

    public static <T> Box<T> ofVolatile(T value) {
        return new BoxImp.Volatile<T>(value);
    }

    public static <T> Box<T> from(final Supplier<T> getter, final Consumer<T> setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new Box<T>(){

            @Override
            public T get() {
                return Objects.requireNonNull(getter.get());
            }

            @Override
            public void set(T value) {
                setter.accept(Objects.requireNonNull(value));
            }

            public String toString() {
                return "Box.from[" + this.get() + "]";
            }
        };
    }

    public static interface Lng
    extends LongSupplier,
    LongConsumer,
    Box<Long> {
        @Override
        public void set(long var1);

        @Override
        public long getAsLong();

        @Override
        @Deprecated
        default public Long get() {
            return this.getAsLong();
        }

        @Override
        @Deprecated
        default public void set(Long value) {
            this.set((long)value);
        }

        @Override
        @Deprecated
        default public void accept(long value) {
            this.set(value);
        }

        public static Lng of(final long value) {
            return new Lng(){
                private long obj;
                {
                    this.obj = value;
                }

                @Override
                public long getAsLong() {
                    return this.obj;
                }

                @Override
                public void set(long obj) {
                    this.obj = obj;
                }

                public String toString() {
                    return "Box.Lng.of[" + this.getAsLong() + "]";
                }
            };
        }

        public static Lng from(final LongSupplier getter, final LongConsumer setter) {
            return new Lng(){

                @Override
                public long getAsLong() {
                    return getter.getAsLong();
                }

                @Override
                public void set(long value) {
                    setter.accept(value);
                }

                public String toString() {
                    return "Box.Lng.from[" + this.getAsLong() + "]";
                }
            };
        }
    }

    public static interface Int
    extends IntSupplier,
    IntConsumer,
    Box<Integer> {
        @Override
        public void set(int var1);

        @Override
        public int getAsInt();

        @Override
        @Deprecated
        default public Integer get() {
            return this.getAsInt();
        }

        @Override
        @Deprecated
        default public void set(Integer value) {
            this.set((int)value);
        }

        @Override
        @Deprecated
        default public void accept(int value) {
            this.set(value);
        }

        public static Int of(final int value) {
            return new Int(){
                private int obj;
                {
                    this.obj = value;
                }

                @Override
                public int getAsInt() {
                    return this.obj;
                }

                @Override
                public void set(int obj) {
                    this.obj = obj;
                }

                public String toString() {
                    return "Box.Int.of[" + this.getAsInt() + "]";
                }
            };
        }

        public static Int from(final IntSupplier getter, final IntConsumer setter) {
            return new Int(){

                @Override
                public int getAsInt() {
                    return getter.getAsInt();
                }

                @Override
                public void set(int value) {
                    setter.accept(value);
                }

                public String toString() {
                    return "Box.Int.from[" + this.getAsInt() + "]";
                }
            };
        }
    }

    public static interface Dbl
    extends DoubleSupplier,
    DoubleConsumer,
    Box<Double> {
        @Override
        public void set(double var1);

        @Override
        public double getAsDouble();

        @Override
        @Deprecated
        default public Double get() {
            return this.getAsDouble();
        }

        @Override
        @Deprecated
        default public void set(Double value) {
            this.set((double)value);
        }

        @Override
        @Deprecated
        default public void accept(double value) {
            this.set(value);
        }

        public static Dbl of(final double value) {
            return new Dbl(){
                private double obj;
                {
                    this.obj = value;
                }

                @Override
                public double getAsDouble() {
                    return this.obj;
                }

                @Override
                public void set(double obj) {
                    this.obj = obj;
                }

                public String toString() {
                    return "Box.Dbl.of[" + this.getAsDouble() + "]";
                }
            };
        }

        public static Dbl from(final DoubleSupplier getter, final DoubleConsumer setter) {
            return new Dbl(){

                @Override
                public double getAsDouble() {
                    return getter.getAsDouble();
                }

                @Override
                public void set(double value) {
                    setter.accept(value);
                }

                public String toString() {
                    return "Box.Dbl.from[" + this.getAsDouble() + "]";
                }
            };
        }
    }

    public static interface Nullable<T>
    extends Supplier<T>,
    Consumer<T> {
        public void set(@javax.annotation.Nullable T var1);

        @Override
        @Deprecated
        default public void accept(@javax.annotation.Nullable T value) {
            this.set(value);
        }

        default public T modify(Function<? super T, ? extends T> mutator) {
            T modified = mutator.apply(this.get());
            this.set(modified);
            return modified;
        }

        default public <R> Nullable<R> map(ConverterNullable<T, R> converter) {
            return new BoxImp.Nullable.Mapped<T, R>(this, converter);
        }

        public static <T> Nullable<T> ofVolatile(@javax.annotation.Nullable T init) {
            return new BoxImp.Nullable.Volatile<T>(init);
        }

        public static <T> Nullable<T> ofVolatileNull() {
            return Nullable.ofVolatile(null);
        }

        public static <T> Nullable<T> of(@javax.annotation.Nullable T init) {
            return new BoxImp.Nullable.Default<T>(init);
        }

        public static <T> Nullable<T> ofNull() {
            return Nullable.of(null);
        }

        public static <T> Nullable<T> from(final Supplier<T> getter, final Consumer<T> setter) {
            Objects.requireNonNull(getter);
            Objects.requireNonNull(setter);
            return new Nullable<T>(){

                @Override
                public T get() {
                    return getter.get();
                }

                @Override
                public void set(T value) {
                    setter.accept(value);
                }

                public String toString() {
                    return "Box.Nullable.from[" + this.get() + "]";
                }
            };
        }
    }
}

